/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.event;

import net.kapitencraft.kap_lib.client.ModBEWLR;
import net.kapitencraft.kap_lib.client.particle.DamageIndicatorParticle;
import net.kapitencraft.kap_lib.client.particle.LightningParticle;
import net.kapitencraft.kap_lib.client.particle.ShimmerShieldParticle;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.event.custom.client.RegisterUniformsEvent;
import net.kapitencraft.kap_lib.inventory.page_renderer.InventoryPageRenderers;
import net.kapitencraft.kap_lib.item.BaseAttributeUUIDs;
import net.kapitencraft.kap_lib.item.modifier_display.ModifierDisplayManager;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.ExtraParticleTypes;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEventBusClientEvents {
    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)ExtraParticleTypes.DAMAGE_INDICATOR.get(), (ParticleProvider)new DamageIndicatorParticle.Provider());
        event.registerSpecial((ParticleType)ExtraParticleTypes.LIGHTNING.get(), (ParticleProvider)new LightningParticle.Provider());
        event.registerSprite((ParticleType)ExtraParticleTypes.SHIMMER_SHIELD.get(), (ParticleProvider.Sprite)new ShimmerShieldParticle.Provider());
    }

    @SubscribeEvent
    public static void registerUniforms(RegisterUniformsEvent event) {
        event.addVecUniform("ChromaConfig", () -> {
            float[] floats = new float[]{ClientModConfig.getChromaOrigin().getConfigId(), ClientModConfig.getChromaSpacing(), ClientModConfig.getChromaSpeed(), ClientModConfig.getChromaType().getConfigId()};
            return floats;
        });
    }

    @SubscribeEvent
    public static void registerItemProperties(FMLClientSetupEvent event) {
        ItemProperties.register((Item)Items.f_42411_, (ResourceLocation)new ResourceLocation("pull"), (stack, level, living, p_174679_) -> {
            if (living == null || living.m_21051_((Attribute)ExtraAttributes.DRAW_SPEED.get()) == null) {
                return 0.0f;
            }
            return living.m_21211_() != stack ? 0.0f : (float)((double)((float)(stack.m_41779_() - living.m_21212_()) / 20.0f) * living.m_21133_((Attribute)ExtraAttributes.DRAW_SPEED.get()) / 100.0);
        });
        BaseAttributeUUIDs.init();
        ModifierDisplayManager.init();
    }

    @SubscribeEvent
    public void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ModBEWLR.setInstance());
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        InventoryPageRenderers.init();
    }
}

