/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.Command;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.conditions.abstracts.ReqCondition;
import net.kapitencraft.kap_lib.requirements.type.RequirementType;
import net.kapitencraft.kap_lib.util.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FireworkParticles;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class ClientHelper {
    @ApiStatus.Internal
    public static Screen postCommandScreen = null;
    private static final ResourceLocation GUARDIAN_BEAM_LOCATION = new ResourceLocation("textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.m_110458_((ResourceLocation)GUARDIAN_BEAM_LOCATION);

    public static Command<CommandSourceStack> createScreenCommand(Supplier<Screen> creator) {
        return stack -> {
            postCommandScreen = (Screen)creator.get();
            return 1;
        };
    }

    public static void renderBeam(Vec3 start, LivingEntity living, int r, int g, int b, PoseStack stack, MultiBufferSource source, RenderType renderType) {
        float f1 = living.m_9236_().m_46467_();
        float f2 = f1 * 0.5f % 1.0f;
        stack.m_85836_();
        stack.m_85837_(start.f_82479_, start.f_82480_, start.f_82481_);
        Vec3 stop = living.m_20182_().m_82520_(0.0, (double)living.m_20206_() * 0.5, 0.0);
        Vec3 vec32 = stop.m_82546_(start);
        float f4 = (float)(vec32.m_82553_() + 1.0);
        vec32 = vec32.m_82541_();
        float f5 = (float)Math.acos(vec32.f_82480_);
        float f6 = (float)Math.atan2(vec32.f_82481_, vec32.f_82479_);
        stack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
        stack.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f));
        float f7 = f1 * 0.05f * -1.5f;
        float f11 = Mth.m_14089_((float)(f7 + 2.3561945f)) * 0.282f;
        float f12 = Mth.m_14031_((float)(f7 + 2.3561945f)) * 0.282f;
        float f13 = Mth.m_14089_((float)(f7 + 0.7853982f)) * 0.282f;
        float f14 = Mth.m_14031_((float)(f7 + 0.7853982f)) * 0.282f;
        float f15 = Mth.m_14089_((float)(f7 + 3.926991f)) * 0.282f;
        float f16 = Mth.m_14031_((float)(f7 + 3.926991f)) * 0.282f;
        float f17 = Mth.m_14089_((float)(f7 + 5.4977875f)) * 0.282f;
        float f18 = Mth.m_14031_((float)(f7 + 5.4977875f)) * 0.282f;
        float f19 = Mth.m_14089_((float)(f7 + (float)Math.PI)) * 0.2f;
        float f20 = Mth.m_14031_((float)(f7 + (float)Math.PI)) * 0.2f;
        float f21 = Mth.m_14089_((float)(f7 + 0.0f)) * 0.2f;
        float f22 = Mth.m_14031_((float)(f7 + 0.0f)) * 0.2f;
        float f23 = Mth.m_14089_((float)(f7 + 1.5707964f)) * 0.2f;
        float f24 = Mth.m_14031_((float)(f7 + 1.5707964f)) * 0.2f;
        float f25 = Mth.m_14089_((float)(f7 + 4.712389f)) * 0.2f;
        float f26 = Mth.m_14031_((float)(f7 + 4.712389f)) * 0.2f;
        float f29 = -1.0f + f2;
        float f30 = f4 * 2.5f + f29;
        VertexConsumer vertexconsumer = source.m_6299_(renderType);
        PoseStack.Pose pose = stack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f19, f4, f20, r, g, b, 0.4999f, f30);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f19, 0.0f, f20, r, g, b, 0.4999f, f29);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f21, 0.0f, f22, r, g, b, 0.0f, f29);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f21, f4, f22, r, g, b, 0.0f, f30);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f23, f4, f24, r, g, b, 0.4999f, f30);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f23, 0.0f, f24, r, g, b, 0.4999f, f29);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f25, 0.0f, f26, r, g, b, 0.0f, f29);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f25, f4, f26, r, g, b, 0.0f, f30);
        float f31 = 0.0f;
        if (living.f_19797_ % 2 == 0) {
            f31 = 0.5f;
        }
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f11, f4, f12, r, g, b, 0.5f, f31 + 0.5f);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f13, f4, f14, r, g, b, 1.0f, f31 + 0.5f);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f17, f4, f18, r, g, b, 1.0f, f31);
        ClientHelper.vertex(vertexconsumer, matrix4f, matrix3f, f15, f4, f16, r, g, b, 0.5f, f31);
        stack.m_85849_();
    }

    private static void vertex(VertexConsumer p_253637_, Matrix4f p_253920_, Matrix3f p_253881_, float p_253994_, float p_254492_, float p_254474_, int p_254080_, int p_253655_, int p_254133_, float p_254233_, float p_253939_) {
        p_253637_.m_252986_(p_253920_, p_253994_, p_254492_, p_254474_).m_6122_(p_254080_, p_253655_, p_254133_, 255).m_7421_(p_254233_, p_253939_).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(p_253881_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void drawCenteredString(GuiGraphics graphics, int xStart, int yStart, int xEnd, int yEnd, Component toDraw, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int height = yEnd - yStart;
        int width = xEnd - xStart;
        int xDrawStart = xStart + width / 2;
        int yDrawStart = yStart + height / 2 - 4;
        graphics.m_280653_(font, toDraw, xDrawStart, yDrawStart, color);
    }

    public static void changeCursorType(int arrowId) {
        Minecraft minecraft = Minecraft.m_91087_();
        long windowId = minecraft.m_91268_().m_85439_();
        minecraft.execute(() -> GLFW.glfwSetCursor((long)windowId, (long)GLFW.glfwCreateStandardCursor((int)arrowId)));
    }

    public static <T> void addReqContent(Consumer<Component> consumer, RequirementType<T> type, T t, @Nullable LivingEntity living) {
        if (RequirementManager.instance == null) {
            return;
        }
        List<ReqCondition<?>> reqs = CollectionHelper.mutableList(RequirementManager.instance.getReqs(type, t));
        if (living != null) {
            reqs.removeIf(itemRequirement -> itemRequirement.matches(living));
        }
        if (!reqs.isEmpty()) {
            MutableComponent reqList = Component.m_237119_();
            reqs.stream().map(ReqCondition::display).filter(MutableComponent.class::isInstance).map(MutableComponent.class::cast).map(component -> component.m_130940_(ChatFormatting.RED)).forEach(consumer);
        }
    }

    public static boolean hideGui() {
        return Minecraft.m_91087_().f_91066_.f_92062_;
    }

    public static void sendElytraBoostParticles(Entity target, RandomSource random, Vec3 delta, Color startColor, Color fadeColor) {
        Level level = target.m_9236_();
        if (!level.m_5776_()) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        Vec3 loc = MathHelper.getHandHoldingItemAngle(HumanoidArm.LEFT, target);
        ClientHelper.addParticle(clientLevel, loc, random, delta, startColor, fadeColor);
        loc = MathHelper.getHandHoldingItemAngle(HumanoidArm.RIGHT, target);
        ClientHelper.addParticle(clientLevel, loc, random, delta, startColor, fadeColor);
    }

    @ApiStatus.Internal
    private static void addParticle(ClientLevel level, Vec3 loc, RandomSource random, Vec3 delta, Color startColor, Color fadeColor) {
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        SpriteSet spriteSet = (SpriteSet)engine.f_107295_.get(ForgeRegistries.PARTICLE_TYPES.getKey((Object)ParticleTypes.f_123815_.m_6012_()));
        FireworkParticles.SparkParticle particle = new FireworkParticles.SparkParticle(level, loc.f_82479_, loc.f_82480_, loc.f_82481_, random.m_188583_() * 0.05, -delta.f_82480_ * 0.5, random.m_188583_() * 0.05, engine, spriteSet);
        particle.m_107253_(startColor.r(), startColor.g(), startColor.b());
        particle.m_107659_(fadeColor.pack());
        engine.m_107344_((Particle)particle);
    }

    public static void fill(GuiGraphics graphics, float xStart, float yStart, float xEnd, float yEnd, int color, int blitOffset) {
        ClientHelper.innerFill(graphics.m_280168_().m_85850_().m_252922_(), xStart, yStart, xEnd, yEnd, color, blitOffset);
    }

    @ApiStatus.Internal
    private static void innerFill(Matrix4f p_254518_, float xStart, float yStart, float xEnd, float yEnd, int color, int blitOffset) {
        float i;
        if (xStart < xEnd) {
            i = xStart;
            xStart = xEnd;
            xEnd = i;
        }
        if (yStart < yEnd) {
            i = yStart;
            yStart = yEnd;
            yEnd = i;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(p_254518_, xStart, yEnd, (float)blitOffset).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(p_254518_, xEnd, yEnd, (float)blitOffset).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(p_254518_, xEnd, yStart, (float)blitOffset).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(p_254518_, xStart, yStart, (float)blitOffset).m_85950_(f, f1, f2, f3).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static float getScreenWidth() {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91080_, (String)"active screen is null!").f_96543_;
    }

    public static float getScreenHeight() {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91080_, (String)"active screen is null!").f_96544_;
    }

    @NotNull
    public static Entity getEntity(int id) {
        return Objects.requireNonNull(Objects.requireNonNull(Minecraft.m_91087_().f_91073_, "Client Level is null!").m_6815_(id), "missing entity with id " + id);
    }

    @Nullable
    public static Entity getNullableEntity(int id) {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91073_, "Client Level is null!").m_6815_(id);
    }
}

