/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class NetworkHelper {
    public static void writeVec3(FriendlyByteBuf buf, Vec3 vec3) {
        buf.writeDouble(vec3.f_82479_);
        buf.writeDouble(vec3.f_82480_);
        buf.writeDouble(vec3.f_82481_);
    }

    public static void writeVec2(FriendlyByteBuf buf, Vec2 value) {
        buf.writeFloat(value.f_82470_);
        buf.writeFloat(value.f_82471_);
    }

    public static <T> void writeArray(FriendlyByteBuf buf, T[] array, FriendlyByteBuf.Writer<T> writer) {
        buf.writeInt(array.length);
        for (T t : array) {
            writer.accept((Object)buf, t);
        }
    }

    public static <T> T[] readArray(FriendlyByteBuf buf, IntFunction<T[]> constructor, FriendlyByteBuf.Reader<T> reader) {
        int length = buf.readInt();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            list.add(reader.apply((Object)buf));
        }
        return list.toArray(constructor);
    }

    public static Vec3 readVec3(FriendlyByteBuf buf) {
        return new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static Vec2 readVec2(FriendlyByteBuf buf) {
        return new Vec2(buf.readFloat(), buf.readFloat());
    }

    public static <T extends ParticleOptions> T readParticleOptions(FriendlyByteBuf buf) {
        ParticleType type = (ParticleType)buf.m_236816_((IdMap)BuiltInRegistries.f_257034_);
        return (T)Objects.requireNonNull(type).m_123743_().m_6507_(type, buf);
    }

    public static void writeParticleOptions(FriendlyByteBuf buf, ParticleOptions toSpawn) {
        buf.m_236818_((IdMap)BuiltInRegistries.f_257034_, (Object)toSpawn.m_6012_());
        toSpawn.m_7711_(buf);
    }

    public static void writeVector3f(FriendlyByteBuf buf, Vector3f vec) {
        buf.writeFloat(vec.x);
        buf.writeFloat(vec.y);
        buf.writeFloat(vec.z);
    }

    public static Entity entityFromNw(FriendlyByteBuf buf) {
        return ClientHelper.getEntity(buf.readInt());
    }

    public static <K, V> void writeMultimap(FriendlyByteBuf buf, Multimap<K, V> multimap, FriendlyByteBuf.Writer<K> keyWriter, FriendlyByteBuf.Writer<V> valueWriter) {
        buf.m_236831_(CollectionHelper.fromMultimap(multimap), keyWriter, (buf1, vs) -> buf1.m_236828_((Collection)vs, valueWriter));
    }

    public static <K, V> Multimap<K, V> readMultimap(FriendlyByteBuf buf, FriendlyByteBuf.Reader<K> keyReader, FriendlyByteBuf.Reader<V> valueReader) {
        return CollectionHelper.fromListMap(buf.m_236847_(keyReader, buf1 -> (List)buf1.m_236838_(ArrayList::new, valueReader)));
    }
}

