/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.inventory.wearable;

import net.kapitencraft.kap_lib.inventory.wearable.Wearables;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WearableProvider
implements ICapabilitySerializable<ListTag> {
    private final LazyOptional<Wearables> lazy;
    private final Wearables wearable;

    public WearableProvider(LivingEntity living) {
        this.wearable = new Wearables(living);
        this.lazy = LazyOptional.of(() -> this.wearable);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return Wearables.CAPABILITY.orEmpty(cap, this.lazy);
    }

    public ListTag serializeNBT() {
        return this.wearable.save();
    }

    public void deserializeNBT(ListTag nbt) {
        this.wearable.load(nbt);
    }
}

