/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.stream.Stream;
import net.kapitencraft.kap_lib.io.serialization.ExtraJsonSerializers;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public interface JsonHelper {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Stream<JsonObject> castToObjects(JsonArray array) {
        return array.asList().stream().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject);
    }

    public static <T> T getAsRegistryElement(JsonObject pObject, String pMemberName, IForgeRegistry<T> registry) {
        JsonElement pJson = pObject.get(pMemberName);
        if (pJson.isJsonPrimitive()) {
            String s = pJson.getAsString();
            return (T)((Holder)registry.getHolder(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Expected " + pMemberName + " to be of " + registry.getRegistryName() + ", was unknown string '" + s + "'"))).get();
        }
        throw new JsonSyntaxException("Expected " + pMemberName + " to be of " + registry.getRegistryName() + ", was " + GsonHelper.m_13883_((JsonElement)pJson));
    }

    public static <T> void addRegistryElement(JsonObject pJson, String name, T value, IForgeRegistry<T> registry) {
        pJson.addProperty(name, Objects.requireNonNull(registry.getKey(value), "unknown element in registry: " + value).toString());
    }

    public static Vec3 getAsVec3(JsonObject pObject, String id) {
        return (Vec3)ExtraJsonSerializers.VEC_3.parse((Vec3)pObject.get(id));
    }

    @Nullable
    public static Boolean getAsOptionalBool(JsonObject pObject, String name) {
        return pObject.has(name) ? Boolean.valueOf(GsonHelper.m_13912_((JsonObject)pObject, (String)name)) : null;
    }

    @Nullable
    public static Integer getAsOptionalInt(JsonObject pObject, String name) {
        return pObject.has(name) ? Integer.valueOf(GsonHelper.m_13927_((JsonObject)pObject, (String)name)) : null;
    }

    public static void addOptionalBool(JsonObject pJson, String name, Boolean val) {
        if (val != null) {
            pJson.addProperty(name, val);
        }
    }

    public static void addOptionalInt(JsonObject pJson, String name, Integer val) {
        if (val != null) {
            pJson.addProperty(name, (Number)val);
        }
    }

    public static ItemStack getAsItemStack(JsonObject object) {
        Item item = (Item)JsonHelper.getAsRegistryElement(object, "item", ForgeRegistries.ITEMS);
        int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
        CompoundTag tag = object.has("tag") ? CraftingHelper.getNBT((JsonElement)object.get("tag")) : null;
        return new ItemStack((ItemLike)item, count, tag);
    }

    public static void addItemStack(JsonObject pObject, String name, ItemStack stack) {
        JsonObject object = new JsonObject();
        JsonHelper.addRegistryElement(object, "item", stack.m_41720_(), ForgeRegistries.ITEMS);
        if (stack.m_41613_() != 1) {
            object.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41783_() != null) {
            object.addProperty("tag", stack.m_41783_().toString());
        }
        pObject.add(name, (JsonElement)object);
    }
}

