/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io.network.S2C.capability;

import java.util.Map;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.kapitencraft.kap_lib.cooldown.Cooldowns;
import net.kapitencraft.kap_lib.io.network.SimplePacket;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncCooldownsToPlayerPacket
implements SimplePacket {
    private final int playerId;
    private final Map<Cooldown, Integer> data;

    public SyncCooldownsToPlayerPacket(int playerId, Map<Cooldown, Integer> data) {
        this.playerId = playerId;
        this.data = data;
    }

    public SyncCooldownsToPlayerPacket(FriendlyByteBuf buf) {
        this.playerId = buf.readInt();
        this.data = buf.m_236847_(buf1 -> (Cooldown)buf1.readRegistryIdUnsafe(ExtraRegistries.COOLDOWNS), FriendlyByteBuf::readInt);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.playerId);
        buf.m_236831_(this.data, (buf1, cooldown) -> buf1.writeRegistryIdUnsafe(ExtraRegistries.COOLDOWNS, cooldown), FriendlyByteBuf::writeInt);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> sup) {
        sup.get().enqueueWork(() -> {
            Entity patt1520$temp = Minecraft.m_91087_().f_91073_.m_6815_(this.playerId);
            if (patt1520$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt1520$temp;
                Cooldowns.get(living).loadData(this.data);
            }
        });
    }
}

