/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io.network.request;

import java.util.function.Supplier;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.io.network.SimplePacket;
import net.kapitencraft.kap_lib.io.network.request.IRequestable;
import net.kapitencraft.kap_lib.io.network.request.RequestPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class RequestDataPacket<T, K>
implements SimplePacket {
    private final IRequestable<T, K> provider;
    private final short id;
    private final T data;

    public RequestDataPacket(FriendlyByteBuf buf) {
        this.id = buf.readShort();
        this.provider = RequestPacket.getRequestable(buf.m_130277_());
        this.data = this.provider.getFromNetwork(buf);
    }

    public short getId() {
        return this.id;
    }

    public RequestDataPacket(short requestId, IRequestable<T, K> provider, T data) {
        this.id = requestId;
        this.provider = provider;
        this.data = data;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeShort((int)this.id);
        buf.m_130070_(RequestPacket.saveRequestable(this.provider));
        this.provider.writeToNetwork(this.data, buf);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> sup) {
        NetworkEvent.Context context = sup.get();
        context.enqueueWork(() -> LibClient.requests.accordPackageReceive(this));
    }

    public T getData() {
        return this.data;
    }
}

