/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io.serialization;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import java.util.HashMap;
import java.util.Map;

public class BoundMapCodec<K, V>
implements Codec<Map<K, V>> {
    private final Codec<K> keyCodec;
    private final Codec<V> valueCodec;

    public BoundMapCodec(Codec<K> keyCodec, Codec<V> valueCodec) {
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
    }

    public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).flatMap(tMapLike -> {
            HashMap map = new HashMap();
            StringBuilder exception = new StringBuilder();
            tMapLike.entries().forEach(ttPair -> {
                DataResult key = this.keyCodec.parse(ops, ttPair.getFirst());
                DataResult value = this.valueCodec.parse(ops, ttPair.getSecond());
                key.get().ifLeft(k -> value.get().ifLeft(v -> map.put(k, v)).ifRight(partial -> {
                    exception.append(" value error: ");
                    exception.append(partial.message());
                })).ifRight(partial -> {
                    exception.append(" key error: ");
                    exception.append(partial.message());
                });
            });
            if (!exception.isEmpty()) {
                return DataResult.error(exception::toString);
            }
            return DataResult.success((Object)Pair.of(map, (Object)input));
        });
    }

    public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
        RecordBuilder builder = ops.mapBuilder();
        input.forEach((k, v) -> builder.add(this.keyCodec.encodeStart(ops, k), this.valueCodec.encodeStart(ops, v)));
        return builder.build(prefix);
    }
}

