/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.bonus;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.BonusRemovedTerminator;
import net.kapitencraft.kap_lib.collection.DoubleMap;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.event.custom.RegisterBonusProvidersEvent;
import net.kapitencraft.kap_lib.event.custom.WearableSlotChangeEvent;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.InventoryHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.io.JsonHelper;
import net.kapitencraft.kap_lib.io.network.ModMessages;
import net.kapitencraft.kap_lib.io.network.S2C.UpdateBonusDataPacket;
import net.kapitencraft.kap_lib.item.bonus.AbstractBonusElement;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.registry.ExtraCodecs;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.TerminatorTriggers;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.type.RequirementType;
import net.kapitencraft.kap_lib.util.Color;
import net.kapitencraft.kap_lib.util.Reference;
import net.kapitencraft.kap_lib.util.Vec2i;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod.EventBusSubscriber
public class BonusManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static BonusManager instance;
    private final Map<ResourceLocation, Function<ItemStack, AbstractBonusElement>> providers;
    private final Map<ResourceLocation, SetBonusElement> sets = new HashMap<ResourceLocation, SetBonusElement>();
    private final Map<ResourceLocation, BonusElement> bonusData = new HashMap<ResourceLocation, BonusElement>();
    private final DoubleMap<Item, ResourceLocation, BonusElement> itemBonuses = DoubleMap.create();
    private final Map<LivingEntity, BonusLookup> lookupMap = new HashMap<LivingEntity, BonusLookup>();

    public static BonusManager updateInstance() {
        if (instance != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)instance);
        }
        instance = new BonusManager();
        return instance;
    }

    public static void swapFrom(LivingEntity living, EquipmentSlot slot, ItemStack newItem, ItemStack oldItem) {
        instance.getOrCreateLookup(living).equipmentChange(slot, oldItem, newItem);
    }

    public static float attackEvent(LivingEntity attacked, LivingEntity attacker, MiscHelper.DamageType type, float damage) {
        float[] damageWrapper = new float[]{damage};
        instance.getLookup(attacked).ifPresent(bonusLookup -> bonusLookup.activeBonuses.keySet().forEach(abstractBonusElement -> {
            damageWrapper[0] = abstractBonusElement.getBonus().onTakeDamage(attacked, attacker, type, damageWrapper[0]);
        }));
        if (attacker != null) {
            instance.getLookup(attacker).ifPresent(bonusLookup -> bonusLookup.activeBonuses.keySet().forEach(abstractBonusElement -> {
                damageWrapper[0] = abstractBonusElement.getBonus().onEntityHurt(attacked, attacker, type, damageWrapper[0]);
            }));
        }
        return damageWrapper[0];
    }

    public static void deathEvent(LivingEntity toDie, DamageSource source) {
        LivingEntity attacker = MiscHelper.getAttacker(source);
        MiscHelper.DamageType type = MiscHelper.getDamageType(source);
        if (attacker != null) {
            instance.getLookup(attacker).ifPresent(bonusLookup -> bonusLookup.activeBonuses.keySet().forEach(abstractBonusElement -> abstractBonusElement.getBonus().onEntityKilled(toDie, attacker, type)));
        }
    }

    public static boolean isDisabled(Entity entity, ResourceLocation elementId) {
        boolean bl;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            bl = instance.getLookup(living).map(l -> l.activeBonuses.keySet().stream().noneMatch(e -> e.getId() == elementId)).orElse(true);
        } else {
            bl = true;
        }
        return bl;
    }

    private Optional<BonusLookup> getLookup(LivingEntity living) {
        if (this.lookupMap.containsKey(living)) {
            return Optional.of(this.lookupMap.get(living));
        }
        return Optional.empty();
    }

    private BonusLookup getOrCreateLookup(LivingEntity living) {
        return this.lookupMap.computeIfAbsent(living, x$0 -> new BonusLookup((LivingEntity)x$0));
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntity();
        BonusLookup bonusLookup = this.getOrCreateLookup(entity);
        bonusLookup.equipmentChange(event.getSlot(), event.getFrom(), event.getTo());
        if (entity instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)entity;
            ModMessages.sendToClientPlayer(new UpdateBonusDataPacket(event.getFrom(), event.getTo(), event.getSlot(), entity.m_19879_()), sP);
        }
    }

    @SubscribeEvent
    public void onWearableSlotChange(WearableSlotChangeEvent event) {
        LivingEntity entity = event.getEntity();
        BonusLookup bonusLookup = this.getOrCreateLookup(entity);
        bonusLookup.wearableChange(event.getSlot(), event.getFrom(), event.getTo());
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        this.getLookup(event.getEntity()).ifPresent(BonusLookup::tick);
    }

    public BonusElement getSet(ResourceLocation location) {
        return Objects.requireNonNull(this.sets.get(location), "unknown set bonus: '" + location + "'");
    }

    public BonusElement getItemBonus(ResourceLocation location) {
        return Objects.requireNonNull(this.bonusData.get(location), "unknown item bonus: '" + location + "'");
    }

    public List<AbstractBonusElement> getAllActive(LivingEntity living) {
        return this.getLookup(living).map(BonusLookup::allActive).orElse((List)ImmutableList.of());
    }

    private Map<ResourceLocation, SetBonusElement> getActiveSetBonuses(LivingEntity living) {
        Map<EquipmentSlot, ItemStack> equipment = InventoryHelper.equipment(living);
        HashMap<ResourceLocation, SetBonusElement> bonuses = new HashMap<ResourceLocation, SetBonusElement>();
        this.sets.forEach((location, setBonusElement) -> {
            if (Arrays.stream(EquipmentSlot.values()).allMatch(slot -> !setBonusElement.requiresSlot((EquipmentSlot)slot) || setBonusElement.matchesItem((EquipmentSlot)slot, (ItemStack)equipment.get(slot))) && !setBonusElement.isHidden()) {
                bonuses.put((ResourceLocation)location, (SetBonusElement)setBonusElement);
            }
        });
        return bonuses;
    }

    public BonusManager() {
        super(JsonHelper.GSON, "bonuses");
        MinecraftForge.EVENT_BUS.register((Object)this);
        HashMap<ResourceLocation, Function<ItemStack, AbstractBonusElement>> providers = new HashMap<ResourceLocation, Function<ItemStack, AbstractBonusElement>>();
        RegisterBonusProvidersEvent event = new RegisterBonusProvidersEvent(providers);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.providers = ImmutableMap.copyOf(providers);
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        pProfiler.m_6180_("loading bonuses");
        pObject.forEach((location, element) -> {
            pProfiler.m_6180_("element '" + location + "'");
            if (location.m_135815_().startsWith("set/")) {
                this.readSetElement(location.m_247266_(s -> s.substring(4)), (JsonElement)element);
            } else {
                this.readItemElement((ResourceLocation)location, (JsonElement)element);
            }
            pProfiler.m_7238_();
        });
        pProfiler.m_7238_();
    }

    private void readItemElement(ResourceLocation location, JsonElement element) {
        try {
            JsonObject main = element.getAsJsonObject();
            DataResult result = ExtraCodecs.BONUS.parse((DynamicOps)JsonOps.INSTANCE, (Object)main);
            Bonus bonus = (Bonus)result.getOrThrow(false, s -> {});
            ResourceLocation itemLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)main, (String)"item"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            if (item == null) {
                throw new IllegalArgumentException("unknown Item: " + itemLocation);
            }
            boolean hidden = main.has("hidden") && GsonHelper.m_13912_((JsonObject)main, (String)"hidden");
            this.addItemIfAbsent(item);
            BonusElement bonusElement = new BonusElement(hidden, bonus, location);
            this.bonusData.put(location, bonusElement);
            this.itemBonuses.putIfAbsent(item, location, bonusElement);
        }
        catch (Exception e) {
            LOGGER.warn(Markers.BONUS_MANAGER, "error loading item bonus '{}': {}", (Object)location, (Object)e.getMessage());
        }
    }

    private void readSetElement(ResourceLocation location, JsonElement jsonElement) {
        try {
            JsonObject main = jsonElement.getAsJsonObject();
            DataResult result = ExtraCodecs.BONUS.parse((DynamicOps)JsonOps.INSTANCE, (Object)main);
            Bonus bonus = (Bonus)result.getOrThrow(false, s -> {});
            EnumMap<EquipmentSlot, TagKey<Item>> itemsForEquipmentSlot = new EnumMap<EquipmentSlot, TagKey<Item>>(EquipmentSlot.class);
            long required = 0L;
            JsonArray array = GsonHelper.m_13933_((JsonObject)main, (String)"equipment_slots");
            for (JsonElement element : array) {
                EquipmentSlot slot = EquipmentSlot.m_20747_((String)element.getAsString());
                required |= 1L << slot.m_20750_();
                itemsForEquipmentSlot.put(slot, TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)location.m_247266_(s -> "set/" + s + "/" + slot.m_20751_())));
            }
            HashMap<WearableSlot, TagKey<Item>> itemsForWearableSlot = new HashMap<WearableSlot, TagKey<Item>>();
            JsonArray array2 = GsonHelper.m_13933_((JsonObject)main, (String)"wearable_slots");
            for (JsonElement element : array2) {
                ResourceLocation location1 = new ResourceLocation(element.getAsString());
                WearableSlot slot = (WearableSlot)ExtraRegistries.WEARABLE_SLOTS.getValue(location1);
                if (slot == null) {
                    throw new IllegalStateException("unknown wearable slot: " + location1);
                }
                required |= 1L << slot.getSlotIndex() + 6;
                itemsForWearableSlot.put(slot, (TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)location.m_247266_(s -> "set/" + s + "/wearable/" + location1.m_135827_() + "/" + location1.m_135815_())));
            }
            boolean hidden = main.has("hidden") && GsonHelper.m_13912_((JsonObject)main, (String)"hidden");
            this.sets.put(location, new SetBonusElement(hidden, bonus, location, itemsForEquipmentSlot, itemsForWearableSlot, required));
        }
        catch (Exception e) {
            LOGGER.warn(Markers.BONUS_MANAGER, "error loading set bonus '{}': {}", (Object)location, (Object)e.getMessage());
        }
    }

    private void addItemIfAbsent(Item item) {
        if (!this.itemBonuses.containsKey(item)) {
            this.itemBonuses.put(item, new HashMap());
        }
    }

    private Map<ResourceLocation, AbstractBonusElement> getBonusesForItem(ItemStack stack, boolean ignoreHidden) {
        Map itemBonuses = MapStream.of(Objects.requireNonNullElse((Map)this.itemBonuses.get(stack.m_41720_()), Map.of())).filterValues(bonusElement -> !bonusElement.hidden || ignoreHidden, null).toMap();
        Map<ResourceLocation, SetBonusElement> setBonuses = MapStream.of(this.sets).filter((location, setBonusElement) -> {
            if (setBonusElement.itemsForEquipmentSlot.values().stream().anyMatch(arg_0 -> ((ItemStack)stack).m_204117_(arg_0))) return true;
            if (!setBonusElement.itemsForWearableSlot.values().stream().anyMatch(arg_0 -> ((ItemStack)stack).m_204117_(arg_0))) return false;
            return true;
        }).toMap();
        Map<ResourceLocation, AbstractBonusElement> extended = this.getAllExtended(stack);
        ImmutableMap.Builder allBonuses = new ImmutableMap.Builder();
        allBonuses.putAll(itemBonuses);
        allBonuses.putAll(setBonuses);
        allBonuses.putAll(extended);
        return allBonuses.build();
    }

    private Map<ResourceLocation, AbstractBonusElement> getAllExtended(ItemStack stack) {
        HashMap<ResourceLocation, AbstractBonusElement> extended = new HashMap<ResourceLocation, AbstractBonusElement>();
        this.providers.forEach((location, provider) -> {
            AbstractBonusElement e = (AbstractBonusElement)provider.apply(stack);
            if (e != null) {
                extended.put((ResourceLocation)location, e);
            }
        });
        return extended;
    }

    @ApiStatus.Internal
    private Map<ResourceLocation, BonusElement> getActiveBonuses(LivingEntity living) {
        HashMap<ResourceLocation, BonusElement> bonuses = new HashMap<ResourceLocation, BonusElement>();
        InventoryHelper.equipment(living).values().stream().map(ItemStack::m_41720_).map(this.itemBonuses::get).filter(Objects::nonNull).forEach(bonuses::putAll);
        bonuses.putAll(this.getActiveSetBonuses(living));
        return bonuses;
    }

    public static List<Component> getBonusDisplay(ItemStack stack, @Nullable LivingEntity living) {
        if (instance == null) {
            return List.of();
        }
        Map<ResourceLocation, AbstractBonusElement> available = instance.getBonusesForItem(stack, false);
        ArrayList<Component> components = new ArrayList<Component>();
        available.forEach((location, bonus) -> {
            if (!bonus.isHidden()) {
                components.addAll(instance.decorateBonus(living, (AbstractBonusElement)bonus));
            }
        });
        return components;
    }

    private List<Component> decorateBonus(@Nullable LivingEntity living, AbstractBonusElement element) {
        ArrayList<Component> decoration = new ArrayList<Component>();
        boolean enabled = RequirementManager.instance.meetsRequirements(RequirementType.BONUS, element, living);
        String nameKey = element.getNameId();
        decoration.add(this.getBonusTitle(enabled, living, nameKey, element));
        decoration.addAll(TextHelper.getDescriptionOrEmpty(nameKey, null, new Object[0]));
        if (!enabled) {
            ClientHelper.addReqContent(decoration::add, RequirementType.BONUS, element, living);
        }
        return decoration;
    }

    private Component getBonusTitle(boolean enabled, @Nullable LivingEntity living, String title, AbstractBonusElement element) {
        MutableComponent name = Component.m_237115_((String)title);
        MutableComponent start = element.getTitle().m_130944_(new ChatFormatting[]{enabled ? ChatFormatting.GOLD : ChatFormatting.DARK_GRAY, ChatFormatting.BOLD});
        MutableComponent join1 = start.m_130946_(": ").m_7220_((Component)name);
        if (element instanceof SetBonusElement) {
            SetBonusElement setBonusElement = (SetBonusElement)element;
            Vec2i count = this.getSetBonusCount(living, setBonusElement);
            TextColor color = !enabled || count.x == 0 ? TextColor.m_131270_((ChatFormatting)ChatFormatting.RED) : Color.fromFormatting(ChatFormatting.GREEN).mix(Color.fromFormatting(ChatFormatting.RED), (float)count.x / (float)count.y).toTextColor();
            join1.m_130946_(" (").m_7220_((Component)Component.m_237113_((String)String.valueOf(count.x)).m_130938_(style -> style.m_131148_(color))).m_130946_("/").m_7220_((Component)Component.m_237113_((String)String.valueOf(count.y)).m_130940_(ChatFormatting.DARK_AQUA)).m_130946_(")");
        }
        return join1;
    }

    private Vec2i getSetBonusCount(@Nullable LivingEntity living, SetBonusElement element) {
        if (living == null) {
            return Vec2i.ZERO;
        }
        Optional<BonusLookup> optional = this.getLookup(living);
        int elementCount = Long.bitCount(element.requiredMask);
        if (optional.isPresent()) {
            BonusLookup lookup = optional.get();
            BonusLookup.SetData data = lookup.setData.get(element);
            if (data != null) {
                return new Vec2i(Long.bitCount(data.mask & element.requiredMask), elementCount);
            }
        }
        return new Vec2i(0, elementCount);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.m_236828_(this.sets.values(), SetBonusElement::toNw);
        buf.m_236831_(this.itemBonuses, (buf1, item) -> buf1.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, item), (buf1, map) -> buf1.m_236828_(map.values(), BonusElement::toNw));
    }

    @ApiStatus.Internal
    public static BonusManager fromNw(FriendlyByteBuf buf) {
        BonusManager manager = new BonusManager();
        ArrayList setBonusElements = (ArrayList)buf.m_236838_(ArrayList::new, SetBonusElement::fromNw);
        manager.sets.putAll(setBonusElements.stream().collect(Collectors.toMap(BonusElement::getId, Function.identity())));
        manager.itemBonuses.putAll(buf.m_236847_(buf1 -> (Item)buf1.readRegistryIdUnsafe(ForgeRegistries.ITEMS), buf1 -> ((ArrayList)buf1.m_236838_(ArrayList::new, BonusElement::fromNw)).stream().collect(Collectors.toMap(BonusElement::getId, Function.identity()))));
        return manager;
    }

    private class BonusLookup {
        private final LivingEntity target;
        private final Map<AbstractBonusElement, Reference<Integer>> activeBonuses = new HashMap<AbstractBonusElement, Reference<Integer>>();
        private final Map<SetBonusElement, SetData> setData = new HashMap<SetBonusElement, SetData>();

        private BonusLookup(LivingEntity target) {
            BonusManager.this.getActiveBonuses(target).values().forEach(element -> this.activeBonuses.put((AbstractBonusElement)element, Reference.of(0)));
            this.target = target;
        }

        public void tick() {
            this.activeBonuses.forEach((element, integer) -> {
                Bonus<?> bonus = element.getBonus();
                if (bonus.isEffectTick(integer.getIntValue(), this.target)) {
                    bonus.onTick(integer.getIntValue(), this.target);
                }
                integer.setValue(integer.getIntValue() + 1);
            });
        }

        public void equipmentChange(EquipmentSlot slot, @NotNull ItemStack from, @NotNull ItemStack to) {
            Multimap<Attribute, AttributeModifier> modifiers;
            Bonus<?> bonus;
            SetData data;
            ImmutableList previous = ImmutableList.copyOf(BonusManager.this.getBonusesForItem(from, true).values());
            ImmutableList next = ImmutableList.copyOf(BonusManager.this.getBonusesForItem(to, true).values());
            for (AbstractBonusElement element : previous) {
                if (next.contains(element)) continue;
                if (element instanceof SetBonusElement) {
                    SetBonusElement setBonusElement2 = (SetBonusElement)element;
                    data = this.setData.get(element);
                    if (!setBonusElement2.requiresSlot(slot) || !setBonusElement2.matchesItem(slot, from)) continue;
                    data.removeEquipment(slot);
                }
                this.activeBonuses.remove(element);
                bonus = element.getBonus();
                bonus.onRemove(this.target);
                if (this.target.m_9236_().m_5776_()) {
                    ((BonusRemovedTerminator)TerminatorTriggers.BONUS_REMOVED.get()).trigger(this.target.m_19879_(), element.getId());
                }
                if ((modifiers = bonus.getModifiers(this.target)) == null || modifiers.isEmpty()) continue;
                this.target.m_21204_().m_22161_(modifiers);
            }
            for (AbstractBonusElement element : next) {
                if (previous.contains(element)) continue;
                if (element instanceof SetBonusElement) {
                    SetBonusElement setElement = (SetBonusElement)element;
                    if (!setElement.requiresSlot(slot) || !setElement.matchesItem(slot, to)) continue;
                    data = this.setData.computeIfAbsent(setElement, setBonusElement -> new SetData());
                    data.addEquipment(slot);
                    if (!data.checkActive(setElement)) continue;
                }
                bonus = element.getBonus();
                bonus.onApply(this.target);
                modifiers = bonus.getModifiers(this.target);
                if (modifiers != null && !modifiers.isEmpty()) {
                    this.target.m_21204_().m_22178_(modifiers);
                }
                this.activeBonuses.put(element, Reference.of(0));
            }
        }

        public void wearableChange(WearableSlot slot, ItemStack from, ItemStack to) {
            Multimap<Attribute, AttributeModifier> modifiers;
            Bonus<?> bonus;
            SetData data;
            ImmutableList previous = ImmutableList.copyOf(BonusManager.this.getBonusesForItem(from, true).values());
            ImmutableList next = ImmutableList.copyOf(BonusManager.this.getBonusesForItem(to, true).values());
            for (AbstractBonusElement element : previous) {
                if (next.contains(element)) continue;
                if (element instanceof SetBonusElement) {
                    SetBonusElement setBonusElement2 = (SetBonusElement)element;
                    data = this.setData.get(element);
                    if (!setBonusElement2.requiresSlot(slot) || !setBonusElement2.matchesItem(slot, from)) continue;
                    data.removeWearable(slot);
                }
                this.activeBonuses.remove(element);
                bonus = element.getBonus();
                bonus.onRemove(this.target);
                if (this.target.m_9236_().m_5776_()) {
                    ((BonusRemovedTerminator)TerminatorTriggers.BONUS_REMOVED.get()).trigger(this.target.m_19879_(), element.getId());
                }
                if ((modifiers = bonus.getModifiers(this.target)) == null || modifiers.isEmpty()) continue;
                this.target.m_21204_().m_22161_(modifiers);
            }
            for (AbstractBonusElement element : next) {
                if (previous.contains(element)) continue;
                if (element instanceof SetBonusElement) {
                    SetBonusElement setElement = (SetBonusElement)element;
                    if (!setElement.requiresSlot(slot) || !setElement.matchesItem(slot, to)) continue;
                    data = this.setData.computeIfAbsent(setElement, setBonusElement -> new SetData());
                    data.addWearable(slot);
                    if (!data.checkActive(setElement)) continue;
                }
                bonus = element.getBonus();
                bonus.onApply(this.target);
                modifiers = bonus.getModifiers(this.target);
                if (modifiers != null && !modifiers.isEmpty()) {
                    this.target.m_21204_().m_22178_(modifiers);
                }
                this.activeBonuses.put(element, Reference.of(0));
            }
        }

        public List<AbstractBonusElement> allActive() {
            return ImmutableList.copyOf(this.activeBonuses.keySet());
        }

        private static class SetData {
            private long mask = 0L;

            private SetData() {
            }

            public void removeEquipment(EquipmentSlot slot) {
                this.mask &= 1L << slot.m_20750_() ^ 0xFFFFFFFFFFFFFFFFL;
            }

            public void addEquipment(EquipmentSlot slot) {
                this.mask |= 1L << slot.m_20750_();
            }

            public boolean checkActive(SetBonusElement element) {
                return element.requiredMask == this.mask;
            }

            public void addWearable(WearableSlot slot) {
                this.mask |= 1L << slot.getSlotIndex() + 6;
            }

            public void removeWearable(WearableSlot slot) {
                this.mask &= 1L << slot.getSlotIndex() + 6 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
    }

    private static class SetBonusElement
    extends BonusElement {
        private final Map<EquipmentSlot, TagKey<Item>> itemsForEquipmentSlot;
        private final Map<WearableSlot, TagKey<Item>> itemsForWearableSlot;
        private final long requiredMask;

        private SetBonusElement(boolean hidden, Bonus<?> bonus, ResourceLocation location, Map<EquipmentSlot, TagKey<Item>> itemsForEquipmentSlot, Map<WearableSlot, TagKey<Item>> itemsForWearableSlot, long requiredMask) {
            super(hidden, bonus, location);
            this.itemsForEquipmentSlot = itemsForEquipmentSlot;
            this.itemsForWearableSlot = itemsForWearableSlot;
            this.requiredMask = requiredMask;
        }

        public boolean requiresSlot(EquipmentSlot slot) {
            return (this.requiredMask & 1L << slot.m_20750_()) != 0L;
        }

        public boolean requiresSlot(WearableSlot slot) {
            return (this.requiredMask & 1L << slot.getSlotIndex() + 6) != 0L;
        }

        public boolean matchesItem(EquipmentSlot slot, ItemStack stack) {
            return stack.m_204117_(this.itemsForEquipmentSlot.get(slot));
        }

        public boolean matchesItem(WearableSlot slot, ItemStack stack) {
            return stack.m_204117_(this.itemsForWearableSlot.get(slot));
        }

        public static void toNw(FriendlyByteBuf buf, SetBonusElement setBonusElement) {
            BonusElement.toNw(buf, setBonusElement);
            buf.m_236831_(setBonusElement.itemsForEquipmentSlot, FriendlyByteBuf::m_130068_, (buf1, itemTagKey) -> buf1.m_130085_(itemTagKey.f_203868_()));
            buf.m_236831_(setBonusElement.itemsForWearableSlot, (buf1, slot) -> buf1.writeRegistryIdUnsafe(ExtraRegistries.WEARABLE_SLOTS, slot), (buf1, itemTagKey) -> buf1.m_130085_(itemTagKey.f_203868_()));
            buf.writeLong(setBonusElement.requiredMask);
        }

        public static SetBonusElement fromNw(FriendlyByteBuf buf) {
            return new SetBonusElement(buf.readBoolean(), Bonus.fromNw(buf), buf.m_130281_(), buf.m_236847_(buf1 -> (EquipmentSlot)buf1.m_130066_(EquipmentSlot.class), buf1 -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)buf1.m_130281_())), buf.m_236847_(buf1 -> (WearableSlot)buf1.readRegistryIdUnsafe(ExtraRegistries.WEARABLE_SLOTS), buf1 -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)buf1.m_130281_())), buf.readLong());
        }

        @Override
        public MutableComponent getTitle() {
            return Component.m_237115_((String)"set.bonus.name");
        }

        @Override
        public String getNameId() {
            return "set." + super.getNameId();
        }
    }

    public static class BonusElement
    implements AbstractBonusElement {
        private final boolean hidden;
        private final Bonus<?> bonus;
        private final ResourceLocation id;

        private BonusElement(boolean hidden, Bonus<?> bonus, ResourceLocation id) {
            this.hidden = hidden;
            this.bonus = bonus;
            this.id = id;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public Bonus<?> getBonus() {
            return this.bonus;
        }

        public static void toNw(FriendlyByteBuf buf, BonusElement bonusElement) {
            buf.writeBoolean(bonusElement.hidden);
            bonusElement.bonus.toNetwork(buf);
            buf.m_130085_(bonusElement.id);
        }

        public static BonusElement fromNw(FriendlyByteBuf buf) {
            return new BonusElement(buf.readBoolean(), Bonus.fromNw(buf), buf.m_130281_());
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public MutableComponent getTitle() {
            return Component.m_237115_((String)"bonus.name");
        }

        @Override
        public String getNameId() {
            return "bonus." + this.id.m_135827_() + "." + this.id.m_135815_();
        }
    }
}

