/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.capability;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.item.capability.AbstractCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CapabilityProvider<D, C extends AbstractCapability<D>>
implements ICapabilitySerializable<Tag> {
    private final C object;
    private final LazyOptional<C> lazy;
    private final Codec<D> codec;
    private final Capability<C> capability;

    protected CapabilityProvider(C object, Codec<D> codec, Capability<C> capability) {
        this.object = object;
        this.lazy = LazyOptional.of(() -> this.object);
        this.codec = codec;
        this.capability = capability;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return this.capability.orEmpty(cap, this.lazy);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.capability.orEmpty(cap, this.lazy);
    }

    public Tag serializeNBT() {
        DataResult result = this.codec.encodeStart((DynamicOps)NbtOps.f_128958_, this.object.getData());
        return (Tag)result.get().map(Function.identity(), tagPartialResult -> {
            KapLibMod.LOGGER.warn("unable to save capability: {}", (Object)tagPartialResult.message());
            return new ListTag();
        });
    }

    public void deserializeNBT(Tag t) {
        DataResult result = this.codec.parse((DynamicOps)NbtOps.f_128958_, (Object)t);
        Object data = result.get().map(Function.identity(), listPartialResult -> {
            KapLibMod.LOGGER.warn("unable to load capability: {}", (Object)listPartialResult.message());
            return this.fallback();
        });
        this.object.copyFrom((Object)data);
    }

    protected abstract D fallback();
}

