/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.mixin.classes;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.kapitencraft.kap_lib.io.serialization.JsonSerializer;
import net.kapitencraft.kap_lib.registry.ExtraCodecs;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.GsonHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Component.Serializer.class})
public abstract class ComponentSerializerMixin {
    @Shadow
    public abstract MutableComponent deserialize(JsonElement var1, Type var2, JsonDeserializationContext var3) throws JsonParseException;

    @Shadow
    protected abstract void m_130709_(Style var1, JsonObject var2, JsonSerializationContext var3);

    @Unique
    private static JsonSerializer<Component> createSerializer() {
        return new JsonSerializer<Component>(ExtraCodecs.COMPONENT);
    }

    @Inject(method={"deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/network/chat/MutableComponent;"}, at={@At(value="INVOKE", target="Lcom/google/gson/JsonElement;getAsJsonObject()Lcom/google/gson/JsonObject;")}, cancellable=true, remap=false)
    private void moveDeserializeToCodec(JsonElement pJson, Type pTypeOfT, JsonDeserializationContext pContext, CallbackInfoReturnable<MutableComponent> cir) {
        JsonObject object = (JsonObject)pJson;
        MutableComponent mutableComponent = (MutableComponent)ComponentSerializerMixin.createSerializer().m_7561_(object, pContext);
        if (mutableComponent == null) {
            return;
        }
        if (object.has("extra") && object.has("extra")) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)object, (String)"extra");
            if (array.size() <= 0) {
                throw new JsonParseException("Unexpected empty array of components");
            }
            for (int j = 0; j < array.size(); ++j) {
                mutableComponent.m_7220_((Component)this.deserialize(array.get(j), pTypeOfT, pContext));
            }
        }
        mutableComponent.m_6270_((Style)pContext.deserialize(pJson, Style.class));
        cir.setReturnValue((Object)mutableComponent);
    }

    @Overwrite
    public JsonElement serialize(Component pSrc, Type pTypeOfSrc, JsonSerializationContext pContext) {
        JsonObject jsonobject = new JsonObject();
        if (!pSrc.m_7383_().m_131179_()) {
            this.m_130709_(pSrc.m_7383_(), jsonobject, pContext);
        }
        if (!pSrc.m_7360_().isEmpty()) {
            JsonArray jsonarray = new JsonArray();
            for (Component component : pSrc.m_7360_()) {
                jsonarray.add(this.serialize(component, (Type)((Object)Component.class), pContext));
            }
            jsonobject.add("extra", (JsonElement)jsonarray);
        }
        ComponentSerializerMixin.createSerializer().m_6170_(jsonobject, pSrc, pContext);
        return jsonobject;
    }
}

