/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Type;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.SerializerType;
import net.minecraftforge.registries.IForgeRegistry;

public class ForgeGsonAdapterFactory {
    public static <E, T extends SerializerType<E>> Builder<E, T> builder(IForgeRegistry<T> pRegistry, String pId, String pName, Function<E, T> pTypeFunction) {
        return new Builder<E, T>(pRegistry, pId, pName, pTypeFunction);
    }

    public static class Builder<E, T extends SerializerType<E>> {
        private final IForgeRegistry<T> registry;
        private final String elementName;
        private final String typeKey;
        private final Function<E, T> typeGetter;
        @Nullable
        private Pair<T, InlineSerializer<? extends E>> inlineType;
        @Nullable
        private T defaultType;

        Builder(IForgeRegistry<T> pRegistry, String pElementName, String pTypeKey, Function<E, T> pTypeGetter) {
            this.registry = pRegistry;
            this.elementName = pElementName;
            this.typeKey = pTypeKey;
            this.typeGetter = pTypeGetter;
        }

        public Builder<E, T> withInlineSerializer(T pInlineType, InlineSerializer<? extends E> pInlineSerializer) {
            this.inlineType = Pair.of(pInlineType, pInlineSerializer);
            return this;
        }

        public Builder<E, T> withDefaultType(T pDefaultType) {
            this.defaultType = pDefaultType;
            return this;
        }

        public Object build() {
            return new JsonAdapter<E, T>(this.registry, this.elementName, this.typeKey, this.typeGetter, this.defaultType, this.inlineType);
        }
    }

    static class JsonAdapter<E, T extends SerializerType<E>>
    implements JsonDeserializer<E>,
    JsonSerializer<E> {
        private final IForgeRegistry<T> registry;
        private final String elementName;
        private final String typeKey;
        private final Function<E, T> typeGetter;
        @Nullable
        private final T defaultType;
        @Nullable
        private final Pair<T, InlineSerializer<? extends E>> inlineType;

        JsonAdapter(IForgeRegistry<T> pRegistry, String pElementName, String pTypeKey, Function<E, T> pTypeGetter, @Nullable T pDefaultType, @Nullable Pair<T, InlineSerializer<? extends E>> pInlineType) {
            this.registry = pRegistry;
            this.elementName = pElementName;
            this.typeKey = pTypeKey;
            this.typeGetter = pTypeGetter;
            this.defaultType = pDefaultType;
            this.inlineType = pInlineType;
        }

        public E deserialize(JsonElement pJson, Type pTypeOfT, JsonDeserializationContext pContext) throws JsonParseException {
            if (pJson.isJsonObject()) {
                Object t;
                JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)this.elementName);
                String s = GsonHelper.m_13851_((JsonObject)jsonobject, (String)this.typeKey, (String)"");
                if (s.isEmpty()) {
                    t = this.defaultType;
                } else {
                    ResourceLocation resourcelocation = new ResourceLocation(s);
                    t = (SerializerType)this.registry.getValue(resourcelocation);
                }
                if (t == null) {
                    throw new JsonSyntaxException("Unknown type '" + s + "'");
                }
                return (E)t.m_79331_().m_7561_(jsonobject, pContext);
            }
            if (this.inlineType == null) {
                throw new UnsupportedOperationException("Object " + pJson + " can't be deserialized");
            }
            return (E)((InlineSerializer)this.inlineType.getSecond()).deserialize(pJson, pContext);
        }

        public JsonElement serialize(E pSrc, Type pTypeOfSrc, JsonSerializationContext pContext) {
            SerializerType t = (SerializerType)this.typeGetter.apply(pSrc);
            if (this.inlineType != null && this.inlineType.getFirst() == t) {
                return ((InlineSerializer)this.inlineType.getSecond()).serialize(pSrc, pContext);
            }
            if (t == null) {
                throw new JsonSyntaxException("Unknown type: " + pSrc);
            }
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty(this.typeKey, this.registry.getKey((Object)t).toString());
            t.m_79331_().m_6170_(jsonobject, pSrc, pContext);
            return jsonobject;
        }
    }

    public static interface InlineSerializer<T> {
        public JsonElement serialize(T var1, JsonSerializationContext var2);

        public T deserialize(JsonElement var1, JsonDeserializationContext var2);
    }
}

