/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.spawn_table.SpawnTableManager;
import net.kapitencraft.kap_lib.spawn_table.entries.DynamicSpawn;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootParams;

public class SpawnContext
extends LootContext {
    private final Map<ResourceLocation, DynamicSpawn> dynamicSpawns = new HashMap<ResourceLocation, DynamicSpawn>();
    private final SpawnTableManager manager;

    SpawnContext(LootParams params, RandomSource randomsource, LootDataManager lootData, ResourceLocation queriedLootTableId, SpawnTableManager manager) {
        super(params, randomsource, (LootDataResolver)lootData);
        this.manager = manager;
    }

    public void addDynamicSpawn(ResourceLocation pName, Consumer<Entity> pConsumer) {
        DynamicSpawn spawn = this.dynamicSpawns.get(pName);
        if (spawn != null) {
            spawn.createEntity(pConsumer, this);
        }
    }

    public SpawnTableManager getSpawnTableManager() {
        return this.manager;
    }

    public static class Builder {
        private final LootParams params;
        @Nullable
        private RandomSource random;
        private ResourceLocation queriedLootTableId;

        public Builder(LootParams pParams) {
            this.params = pParams;
        }

        public Builder(SpawnContext context) {
            this.params = context.f_78914_;
            this.random = context.f_78907_;
        }

        public Builder withOptionalRandomSeed(long pSeed) {
            if (pSeed != 0L) {
                this.random = RandomSource.m_216335_((long)pSeed);
            }
            return this;
        }

        public Builder withQueriedLootTableId(ResourceLocation queriedLootTableId) {
            this.queriedLootTableId = queriedLootTableId;
            return this;
        }

        public ServerLevel getLevel() {
            return this.params.m_287182_();
        }

        public SpawnContext create(@Nullable ResourceLocation pRandomLocation) {
            ServerLevel serverlevel = this.getLevel();
            MinecraftServer minecraftserver = serverlevel.m_7654_();
            RandomSource randomsource = this.random != null ? this.random : (pRandomLocation != null ? serverlevel.m_287143_(pRandomLocation) : serverlevel.m_213780_());
            return new SpawnContext(this.params, randomsource, minecraftserver.m_278653_(), this.queriedLootTableId, SpawnTableManager.instance);
        }
    }
}

