/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.io.JsonHelper;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolSingletonContainer;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnEntity
extends SpawnPoolSingletonContainer {
    final EntityType<?> entityType;

    SpawnEntity(EntityType<?> pEntity, int pWeight, int pQuality, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions) {
        super(pWeight, pQuality, pConditions, pFunctions);
        this.entityType = pEntity;
    }

    @Override
    public SpawnPoolEntryType getType() {
        return (SpawnPoolEntryType)((Object)SpawnPoolEntries.ENTITY.get());
    }

    @Override
    public void createEntity(Consumer<Entity> pEntityConsumer, SpawnContext pLootContext) {
        Entity entity = this.entityType.m_20615_((Level)pLootContext.m_78952_());
        if (entity == null) {
            KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "entity could not be spawned!");
        }
        pEntityConsumer.accept(entity);
    }

    public static SpawnPoolSingletonContainer.Builder<?> spawnTableEntity(EntityType<?> pEntity) {
        return SpawnEntity.simpleBuilder((p_79583_, p_79584_, p_79585_, p_79586_) -> new SpawnEntity(pEntity, p_79583_, p_79584_, p_79585_, p_79586_));
    }

    public static class Serializer
    extends SpawnPoolSingletonContainer.Serializer<SpawnEntity> {
        @Override
        public void serializeCustom(JsonObject pObject, SpawnEntity pContainer, JsonSerializationContext pConditions) {
            super.serializeCustom(pObject, pContainer, pConditions);
            ResourceLocation resourcelocation = ForgeRegistries.ENTITY_TYPES.getKey(pContainer.entityType);
            if (resourcelocation == null) {
                throw new IllegalArgumentException("Can't serialize unknown item " + pContainer.entityType);
            }
            pObject.addProperty("name", resourcelocation.toString());
        }

        @Override
        protected SpawnEntity deserialize(JsonObject pObject, JsonDeserializationContext pContext, int pWeight, int pQuality, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions) {
            EntityType item = (EntityType)JsonHelper.getAsRegistryElement(pObject, "name", ForgeRegistries.ENTITY_TYPES);
            return new SpawnEntity(item, pWeight, pQuality, pConditions, pFunctions);
        }
    }
}

