/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.Predicate;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.entries.AlternativesEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.ComposableEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.EntryGroup;
import net.kapitencraft.kap_lib.spawn_table.entries.SequentialEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SpawnPoolEntryContainer
implements ComposableEntryContainer {
    protected final LootItemCondition[] conditions;
    private final Predicate<LootContext> compositeCondition;

    protected SpawnPoolEntryContainer(LootItemCondition[] pConditions) {
        this.conditions = pConditions;
        this.compositeCondition = LootItemConditions.m_81834_((Predicate[])pConditions);
    }

    public void validate(ValidationContext pValidationContext) {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i].m_6169_(pValidationContext.m_79365_(".condition[" + i + "]"));
        }
    }

    protected final boolean canRun(SpawnContext pLootContext) {
        return this.compositeCondition.test(pLootContext);
    }

    public abstract SpawnPoolEntryType getType();

    public static abstract class Serializer<T extends SpawnPoolEntryContainer>
    implements net.minecraft.world.level.storage.loot.Serializer<T> {
        public final void serialize(JsonObject pJson, T pValue, JsonSerializationContext pSerializationContext) {
            if (!ArrayUtils.isEmpty((Object[])((SpawnPoolEntryContainer)pValue).conditions)) {
                pJson.add("conditions", pSerializationContext.serialize((Object)((SpawnPoolEntryContainer)pValue).conditions));
            }
            this.serializeCustom(pJson, pValue, pSerializationContext);
        }

        public final T deserialize(JsonObject pJson, JsonDeserializationContext pSerializationContext) {
            LootItemCondition[] alootitemcondition = (LootItemCondition[])GsonHelper.m_13845_((JsonObject)pJson, (String)"conditions", (Object)new LootItemCondition[0], (JsonDeserializationContext)pSerializationContext, LootItemCondition[].class);
            return this.deserializeCustom(pJson, pSerializationContext, alootitemcondition);
        }

        public abstract void serializeCustom(JsonObject var1, T var2, JsonSerializationContext var3);

        public abstract T deserializeCustom(JsonObject var1, JsonDeserializationContext var2, LootItemCondition[] var3);
    }

    public static abstract class Builder<T extends Builder<T>>
    implements ConditionUserBuilder<T> {
        private final List<LootItemCondition> conditions = Lists.newArrayList();

        protected abstract T getThis();

        public T when(LootItemCondition.Builder pConditionBuilder) {
            this.conditions.add(pConditionBuilder.m_6409_());
            return this.getThis();
        }

        public final T unwrap() {
            return this.getThis();
        }

        protected LootItemCondition[] getConditions() {
            return this.conditions.toArray(new LootItemCondition[0]);
        }

        public AlternativesEntry.Builder otherwise(Builder<?> pChildBuilder) {
            return new AlternativesEntry.Builder(this, pChildBuilder);
        }

        public EntryGroup.Builder append(Builder<?> pChildBuilder) {
            return new EntryGroup.Builder(this, pChildBuilder);
        }

        public SequentialEntry.Builder then(Builder<?> pChildBuilder) {
            return new SequentialEntry.Builder(this, pChildBuilder);
        }

        public abstract SpawnPoolEntryContainer build();
    }
}

