/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolSingletonContainer;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SpawnTableReference
extends SpawnPoolSingletonContainer {
    final ResourceLocation name;

    SpawnTableReference(ResourceLocation pLootTableId, int pWeight, int pQuality, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions) {
        super(pWeight, pQuality, pConditions, pFunctions);
        this.name = pLootTableId;
    }

    @Override
    public SpawnPoolEntryType getType() {
        return (SpawnPoolEntryType)((Object)SpawnPoolEntries.REFERENCE.get());
    }

    @Override
    public void createEntity(Consumer<Entity> pStackConsumer, SpawnContext pLootContext) {
        SpawnTable spawnTable = pLootContext.getSpawnTableManager().getSpawnTable(this.name);
        if (spawnTable == null) {
            KapLibMod.LOGGER.warn(Markers.SPAWN_TABLE_MANAGER, "unknown spawn table: {}", (Object)this.name);
        } else {
            spawnTable.getRandomEntities(pLootContext, pStackConsumer);
        }
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        LootDataId lootdataid = new LootDataId(LootDataType.f_278413_, this.name);
        if (pValidationContext.m_278820_(lootdataid)) {
            pValidationContext.m_79357_("Table " + this.name + " is recursively called");
        } else {
            super.validate(pValidationContext);
            pValidationContext.m_278720_().m_278739_(lootdataid).ifPresentOrElse(p_279078_ -> p_279078_.m_79136_(pValidationContext.m_278632_("->{" + this.name + "}", lootdataid)), () -> pValidationContext.m_79357_("Unknown loot table called " + this.name));
        }
    }

    public static SpawnPoolSingletonContainer.Builder<?> spawnTableReference(ResourceLocation pTable) {
        return SpawnTableReference.simpleBuilder((p_79780_, p_79781_, p_79782_, p_79783_) -> new SpawnTableReference(pTable, p_79780_, p_79781_, p_79782_, p_79783_));
    }

    public static class Serializer
    extends SpawnPoolSingletonContainer.Serializer<SpawnTableReference> {
        @Override
        public void serializeCustom(JsonObject pObject, SpawnTableReference pContainer, JsonSerializationContext pConditions) {
            super.serializeCustom(pObject, pContainer, pConditions);
            pObject.addProperty("name", pContainer.name.toString());
        }

        @Override
        protected SpawnTableReference deserialize(JsonObject pObject, JsonDeserializationContext pContext, int pWeight, int pQuality, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)pObject, (String)"name"));
            return new SpawnTableReference(resourcelocation, pWeight, pQuality, pConditions, pFunctions);
        }
    }
}

