/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetArmorFunction
extends SpawnEntityConditionalFunction {
    private final LootTable[] armorItems;
    private final float[] armorDropChances;

    protected SetArmorFunction(LootItemCondition[] pPredicates, LootTable[] armorItems, float[] armorDropChances) {
        super(pPredicates);
        this.armorItems = armorItems;
        this.armorDropChances = armorDropChances;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof Mob) {
            Mob mob = (Mob)pEntity;
            EquipmentSlot[] armor = MiscHelper.ARMOR_EQUIPMENT;
            for (int i = 0; i < armor.length; ++i) {
                EquipmentSlot slot = armor[i];
                if (this.armorItems[i] != null) {
                    this.armorItems[i].m_79148_((LootContext)pContext, stack -> pEntity.m_8061_(slot, stack));
                }
                if (this.armorDropChances == null) continue;
                mob.m_21409_(slot, this.armorDropChances[i]);
            }
        } else {
            SetArmorFunction.logWrongType("Mob", pEntity);
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType getType() {
        return (SpawnEntityFunctionType)((Object)SpawnEntityFunctions.SET_ARMOR.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private final LootTable[] items = new LootTable[4];
        private float[] dropChances = null;

        public Builder withItem(EquipmentSlot slot, LootPool.Builder entry) {
            if (!slot.m_254934_()) {
                throw new IllegalArgumentException("can not set armor item of non-armor slot");
            }
            this.items[slot.m_20749_()] = LootTable.m_79147_().m_79161_(entry.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_165135_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79167_();
            return this;
        }

        public Builder withItem(EquipmentSlot slot, ItemLike item) {
            return this.withItem(slot, LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item)));
        }

        public Builder withDropChance(EquipmentSlot slot, float chance) {
            if (!slot.m_254934_()) {
                throw new IllegalArgumentException("can not set armor item of non-armor slot");
            }
            if (this.dropChances == null) {
                this.dropChances = new float[4];
            }
            this.dropChances[slot.m_20749_()] = chance;
            return this;
        }

        public Builder withItemAndDropChance(EquipmentSlot slot, LootPool.Builder entry, float chance) {
            return this.withItem(slot, entry).withDropChance(slot, chance);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return new SetArmorFunction(this.getConditions(), this.items, this.dropChances);
        }
    }

    public static class Serializer
    extends SpawnEntityConditionalFunction.Serializer<SetArmorFunction> {
        @Override
        public void serialize(JsonObject pJson, SetArmorFunction pFunction, JsonSerializationContext pSerializationContext) {
            super.serialize(pJson, pFunction, pSerializationContext);
            pJson.add("armorItems", pSerializationContext.serialize((Object)pFunction.armorItems));
            if (pFunction.armorDropChances != null) {
                pJson.add("armorDropChances", pSerializationContext.serialize((Object)pFunction.armorDropChances));
            }
        }

        @Override
        public SetArmorFunction deserialize(JsonObject pObject, JsonDeserializationContext pDeserializationContext, LootItemCondition[] pConditions) {
            LootTable[] armorItems = pObject.has("armorItems") ? (LootTable[])pDeserializationContext.deserialize(pObject.get("armorItems"), LootTable[].class) : new LootTable[4];
            float[] armorChances = pObject.has("armorChances") ? (float[])pDeserializationContext.deserialize(pObject.get("armorChances"), float[].class) : null;
            return new SetArmorFunction(pConditions, armorItems, armorChances);
        }
    }
}

