/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import com.mojang.serialization.Codec;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.Range;

public record Color(float r, float g, float b, float a) {
    public static final Codec<Color> CODEC = Codec.INT.xmap(Color::fromARGBPacked, Color::pack);

    public static Color fromFormatting(ChatFormatting formatting) {
        return Color.fromARGBPacked(formatting.m_126665_());
    }

    public static Color fromARGBPacked(int packed) {
        return new Color((float)(packed >> 16 & 0xFF) / 255.0f, (float)(packed >> 8 & 0xFF) / 255.0f, (float)(packed & 0xFF) / 255.0f, (float)(packed >> 24 & 0xFF) / 255.0f);
    }

    public Color mul(float scale) {
        return new Color(this.r * scale, this.g * scale, this.b * scale, this.a * scale);
    }

    public Color add(Color other) {
        return new Color(this.r + other.r, this.g + other.g, this.b + other.b, this.a + other.a);
    }

    public Color setAlpha(float alpha) {
        return new Color(this.r, this.g, this.b, alpha);
    }

    public Color merge(Color other) {
        return this.add(other).mul(0.5f);
    }

    public int pack() {
        return MathHelper.ARGBtoInt((int)(this.a * 255.0f), (int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f));
    }

    public Color mix(Color other, @Range(from=0L, to=1L) float percentage) {
        return other.mul(1.0f - percentage).add(this.mul(percentage));
    }

    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeInt(this.pack());
    }

    public static Color read(FriendlyByteBuf buf) {
        return Color.fromARGBPacked(buf.readInt());
    }

    public TextColor toTextColor() {
        return TextColor.m_131266_((int)this.pack());
    }
}

