/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import java.util.List;
import net.kapitencraft.kap_lib.data_gen.ModDamageTypes;
import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ManaHandler {
    public static final String OVERFLOW_MANA_ID = "overflowMana";

    @SubscribeEvent
    public static void manaChange(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!ManaHandler.isMagical((LivingEntity)player)) {
            throw new IllegalStateException("detected Player unable to use mana, expecting broken mod-state!");
        }
        ManaHandler.growMana((LivingEntity)player, player.m_21133_((Attribute)ExtraAttributes.MANA_REGEN.get()));
    }

    public static boolean consumeMana(LivingEntity living, double manaToConsume) {
        if (!ManaHandler.hasMana(living, manaToConsume)) {
            return false;
        }
        double mana = ManaHandler.getMana(living);
        double overflow = ManaHandler.getOverflow(living);
        if (overflow > manaToConsume) {
            overflow -= manaToConsume;
            manaToConsume = 0.0;
        } else {
            manaToConsume -= overflow;
            overflow = 0.0;
        }
        if (manaToConsume > 0.0) {
            mana -= manaToConsume;
        }
        ManaHandler.setOverflow(living, overflow);
        ManaHandler.setMana(living, mana);
        return true;
    }

    public static boolean hasMana(LivingEntity living, double manaToConsume) {
        double overflow;
        if (manaToConsume <= 0.0) {
            return true;
        }
        if (!ManaHandler.isMagical(living)) {
            return false;
        }
        double mana = ManaHandler.getMana(living);
        return mana + (overflow = ManaHandler.getOverflow(living)) >= manaToConsume;
    }

    public static double getOverflow(LivingEntity living) {
        return ManaHandler.isMagical(living) ? living.getPersistentData().m_128459_(OVERFLOW_MANA_ID) : 0.0;
    }

    public static double getMana(LivingEntity living) {
        return AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.MANA.get(), living);
    }

    public static void setMana(LivingEntity living, double mana) {
        AttributeInstance instance = living.m_21051_((Attribute)ExtraAttributes.MANA.get());
        if (instance != null) {
            instance.m_22100_(Math.min(mana, living.m_21133_((Attribute)ExtraAttributes.MAX_MANA.get())));
        }
    }

    public static boolean growMana(LivingEntity living, double mana) {
        ManaHandler.setMana(living, ManaHandler.getMana(living) + mana);
        return ManaHandler.isMagical(living);
    }

    public static boolean isMagical(LivingEntity living) {
        return living.m_21051_((Attribute)ExtraAttributes.MANA.get()) != null || living.m_21051_((Attribute)ExtraAttributes.MAX_MANA.get()) != null;
    }

    public static void setOverflow(LivingEntity living, double overflow) {
        if (overflow >= AttributeHelper.getSaveAttributeValue((Attribute)ExtraAttributes.MAX_MANA.get(), living)) {
            living.m_6469_(living.m_269291_().m_269079_(ModDamageTypes.MANA_OVERFLOW_SELF), Float.MAX_VALUE);
            List<LivingEntity> livings = MathHelper.getLivingAround((Entity)living, 5.0);
            for (LivingEntity living1 : livings) {
                living1.m_6469_(living.m_269291_().m_269298_(ModDamageTypes.MANA_OVERFLOW, (Entity)living), (float)(3.4028234663852886E38 * (0.01 * (double)Math.max(5.0f - living1.m_20270_((Entity)living), 0.0f))));
            }
        }
        living.getPersistentData().m_128347_(OVERFLOW_MANA_ID, overflow);
    }
}

