/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.enchantment_color;

import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.UsefulTextures;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentColor;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentColorManager;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentGroup;
import net.kapitencraft.kap_lib.client.enchantment_color.LevelRange;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.client.widget.SelectChatColorWidget;
import net.kapitencraft.kap_lib.client.widget.SelectCountWidget;
import net.kapitencraft.kap_lib.client.widget.SelectEnumWidget;
import net.kapitencraft.kap_lib.client.widget.select.ByNameRegistryElementSelectorWidget;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.util.range.simple.IntegerNumberRange;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ConfigureEnchantmentColorsScreen
extends Screen {
    private static final int ELEMENT_HEIGHT = 70;
    private static final int WIDTH = 404;
    private static final int HEIGHT = 186;
    private static final int SLIDER_WIDTH = 6;
    private static final MutableComponent ADD = Component.m_237113_((String)"+");
    private static final MutableComponent ADD_HOVERED = Component.m_237113_((String)"+").m_130940_(ChatFormatting.BOLD);
    private final EnchantmentColorManager manager;
    private final List<ColorElement> elements = new ArrayList<ColorElement>();
    private int maxScroll;
    private float scrollY;
    private boolean scrolling;
    private int leftPos;
    private int topPos;
    private ColorElement active;
    @Nullable
    private PositionedWidget selector;

    protected ConfigureEnchantmentColorsScreen() {
        super((Component)Component.m_237115_((String)"cec.title"));
        this.manager = EnchantmentColorManager.getInstance();
        List<EnchantmentColor> colors = this.manager.getAllColors();
        colors.stream().map(x$0 -> new ColorElement((EnchantmentColor)x$0)).forEach(this.elements::add);
        this.recalculateScroll();
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 404) / 2;
        this.topPos = (this.f_96544_ - 186) / 2;
        super.m_7856_();
    }

    private void recalculateScroll() {
        this.maxScroll = Math.max(0, 72 * this.elements.size() - 172 + 8);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 404, this.topPos + 186, -12566464);
        pGuiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.topPos + 2, 0xFFFFFF);
        pGuiGraphics.m_280509_(this.leftPos + 2, this.topPos + 12, this.leftPos + 404 - 2, this.topPos + 186 - 2, -11513776);
        pGuiGraphics.m_280588_(this.leftPos + 2, this.topPos + 12, this.leftPos + 404 - 2, this.topPos + 186 - 2);
        for (int i = 0; i < this.elements.size(); ++i) {
            double mouseRelativeX = pMouseX - this.leftPos - 2;
            double mouseRelativeY = (float)(pMouseY - (this.topPos + 12) - i * 72) - this.scrollY;
            this.elements.get(i).render(pGuiGraphics, 72 * i + (int)this.scrollY + 12, pPartialTick, mouseRelativeX, mouseRelativeY, this.getHoveredIndex(pMouseY) == i);
        }
        pGuiGraphics.m_280653_(this.f_96547_, (Component)(this.isAddElementHovered(pMouseX, pMouseY) ? ADD_HOVERED : ADD), this.f_96543_ / 2, 72 * this.elements.size() + (int)this.scrollY + 12 + this.topPos, 0xFFFFFF);
        pGuiGraphics.m_280618_();
        if (this.shouldShowSlider(pMouseX, pMouseY)) {
            float percentage = -this.scrollY / (float)this.maxScroll;
            UsefulTextures.renderSliderWithLine(pGuiGraphics, 6, this.scrolling, percentage, this.leftPos + 404 - 2, this.topPos + 12, 172);
        }
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        if (this.selector != null) {
            this.selector.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        pGuiGraphics.m_280168_().m_85849_();
    }

    private boolean shouldShowSlider(double pMouseX, double pMouseY) {
        return this.scrolling || this.maxScroll > 0 && MathHelper.is2dBetween(pMouseX, pMouseY, this.leftPos + 404 - 2 - 6, this.topPos + 12, this.leftPos + 404 - 2, this.topPos + 186 - 2);
    }

    private boolean sliderHovered(double pMouseY) {
        float positionY = (float)(this.topPos + 12) + -this.scrollY * 164.5f / (float)this.maxScroll;
        return MathHelper.isBetween(pMouseY, positionY, (double)positionY + 7.5);
    }

    private boolean isAddElementHovered(double pMouseX, double pMouseY) {
        if (this.selector != null) {
            return false;
        }
        int yPos = 72 * this.elements.size() + (int)this.scrollY + 12 + this.topPos;
        return MathHelper.is2dBetween(pMouseX, pMouseY, this.f_96543_ / 2 - 4, yPos, this.f_96543_ / 2 + 4, yPos + 8);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.selector != null) {
            return this.selector.m_6375_(pMouseX, pMouseY, pButton);
        }
        if (this.shouldShowSlider(pMouseX, pMouseY)) {
            if (this.sliderHovered(pMouseY)) {
                this.scrolling = true;
            } else {
                double targetYPos = pMouseY - 3.75;
                this.scrollY = (float)(((double)(this.topPos + 12) - targetYPos) * (double)this.maxScroll / 164.5);
                this.scrollY = Mth.m_14036_((float)this.scrollY, (float)(-this.maxScroll), (float)0.0f);
            }
            return true;
        }
        int index = this.getHoveredIndex((int)pMouseY);
        if (index != -1) {
            ColorElement hovered = this.elements.get(index);
            hovered.mouseClicked(pMouseX - (double)this.leftPos - 2.0, pMouseY - (double)(this.topPos + 12) - (double)(index * 72) - (double)this.scrollY, pButton);
            this.active = hovered;
            return true;
        }
        if (this.isAddElementHovered(pMouseX, pMouseY)) {
            this.elements.add(new ColorElement(EnchantmentColor.create(I18n.m_118938_((String)"enchantment_colors.by_id", (Object[])new Object[]{this.elements.size() + 1}), new ArrayList<Enchantment>(), new ArrayList<EnchantmentGroup>(), null, Style.f_131099_)));
            this.recalculateScroll();
        }
        return false;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (this.selector != null) {
            return this.selector.m_6348_(pMouseX, pMouseY, pButton);
        }
        this.active = null;
        this.scrolling = false;
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.selector != null) {
            return this.selector.m_6050_(pMouseX, pMouseY, pDelta);
        }
        if (MathHelper.is2dBetween(pMouseX, pMouseY, this.leftPos + 2, this.topPos + 12, this.leftPos + 404 - 2, this.topPos + 186 - 2)) {
            this.scrollY += (float)((int)(pDelta * ClientModConfig.getScrollScale()));
            this.scrollY = Mth.m_14036_((float)this.scrollY, (float)(-this.maxScroll), (float)0.0f);
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.selector != null) {
            return this.selector.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        if (this.scrolling) {
            this.scrollY = (float)(Mth.m_14008_((double)(pMouseY - (double)(this.topPos + 12)), (double)0.0, (double)172.0) * (double)(-this.maxScroll) / 172.0);
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private ColorElement getForYPos(int y) {
        int hovered = this.getHoveredIndex(y);
        return hovered == -1 ? null : this.elements.get(hovered);
    }

    private int getHoveredIndex(int y) {
        if (this.selector != null) {
            return -1;
        }
        int index = (this.topPos + (int)this.scrollY + 12 - y) / -72;
        return index < 0 || index >= this.elements.size() ? -1 : index;
    }

    public void m_7379_() {
        this.manager.save(this.elements.stream().map(ColorElement::color).toList());
        super.m_7379_();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            if (this.selector != null) {
                this.selector = null;
            } else {
                this.m_7379_();
            }
            return true;
        }
        return false;
    }

    private class ColorElement {
        private String name;
        private SelectChatColorWidget.ColorType colorType;
        @Nullable
        private LevelRange levelRange;
        private boolean bold;
        private boolean underlined;
        private boolean italic;
        private final List<Enchantment> enchantments;
        private final List<EnchantmentGroup> groups;

        private ColorElement(EnchantmentColor color) {
            this.colorType = SelectChatColorWidget.getColor(color);
            Style style = color.targetStyle();
            this.bold = style.m_131154_();
            this.underlined = style.m_131171_();
            this.italic = style.m_131161_();
            this.levelRange = color.levelRange();
            this.name = color.name();
            this.enchantments = color.elements();
            this.groups = color.groups();
        }

        public void render(GuiGraphics guiGraphics, int yOffset, float pPartialTick, double mouseRelativeX, double mouseRelativeY, boolean hovered) {
            int yPos = ConfigureEnchantmentColorsScreen.this.topPos + yOffset;
            guiGraphics.m_280509_(ConfigureEnchantmentColorsScreen.this.leftPos + 3, yPos, ConfigureEnchantmentColorsScreen.this.leftPos + 404 - 3, yPos + 70, hovered ? -7237231 : -7829368);
            guiGraphics.m_280430_(ConfigureEnchantmentColorsScreen.this.f_96547_, (Component)Component.m_237113_((String)this.name).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE}), ConfigureEnchantmentColorsScreen.this.leftPos + 7, yPos + 1, 0xFFFFFF);
            guiGraphics.m_280509_(ConfigureEnchantmentColorsScreen.this.leftPos + 5, yPos + 10, ConfigureEnchantmentColorsScreen.this.leftPos + 80, yPos + 60, -12566464);
            guiGraphics.m_280588_(ConfigureEnchantmentColorsScreen.this.leftPos + 5, yPos + 10, ConfigureEnchantmentColorsScreen.this.leftPos + 80, yPos + 60);
            for (int i = 0; i < this.enchantments.size(); ++i) {
                Enchantment enchantment = this.enchantments.get(i);
                guiGraphics.m_280430_(ConfigureEnchantmentColorsScreen.this.f_96547_, (Component)Component.m_237115_((String)enchantment.m_44704_()), ConfigureEnchantmentColorsScreen.this.leftPos + 6, yPos + 11 + i * 10, 0xFFFFFF);
                boolean enchantmentHovered = MathHelper.is2dBetween(mouseRelativeX, mouseRelativeY, 5, 11 + i * 10, 80, 21 + i * 10);
                if (!enchantmentHovered) continue;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                UsefulTextures.renderCross(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 71, yPos + 11 + i * 10, 8);
                guiGraphics.m_280168_().m_85849_();
            }
            guiGraphics.m_280430_(ConfigureEnchantmentColorsScreen.this.f_96547_, (Component)(this.isEnchantmentAddHovered(mouseRelativeX, mouseRelativeY) ? ADD_HOVERED : ADD), ConfigureEnchantmentColorsScreen.this.leftPos + 6, yPos + 11 + this.enchantments.size() * 10, 0xFFFFFF);
            guiGraphics.m_280618_();
            guiGraphics.m_280509_(ConfigureEnchantmentColorsScreen.this.leftPos + 81, yPos + 10, ConfigureEnchantmentColorsScreen.this.leftPos + 161, yPos + 60, -12566464);
            guiGraphics.m_280588_(ConfigureEnchantmentColorsScreen.this.leftPos + 81, yPos + 10, ConfigureEnchantmentColorsScreen.this.leftPos + 161, yPos + 60);
            int groupCount = this.groups.size();
            for (int i = 0; i < groupCount; ++i) {
                EnchantmentGroup group = this.groups.get(i);
                guiGraphics.m_280430_(ConfigureEnchantmentColorsScreen.this.f_96547_, group.getName(), ConfigureEnchantmentColorsScreen.this.leftPos + 82, yPos + 11 + i * 10, 0xFFFFFF);
                boolean groupHovered = MathHelper.is2dBetween(mouseRelativeX, mouseRelativeY, 81, 11 + i * 10, 161, 21 + i * 10);
                if (!groupHovered) continue;
                UsefulTextures.renderCross(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 152, yPos + 11 + i * 10, 8);
            }
            if (groupCount < EnchantmentGroup.values().length) {
                guiGraphics.m_280430_(ConfigureEnchantmentColorsScreen.this.f_96547_, (Component)(this.isGroupAddHovered(mouseRelativeX, mouseRelativeY) ? ADD_HOVERED : ADD), ConfigureEnchantmentColorsScreen.this.leftPos + 82, yPos + 11 + groupCount * 10, 0xFFFFFF);
            }
            guiGraphics.m_280618_();
            boolean levelCheckActive = this.levelRange != null;
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 165, yPos + 11, -10461088, levelCheckActive, ConfigureEnchantmentColorsScreen.this.f_96547_, -1, (Component)Component.m_237115_((String)"cec.enable_level"));
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 165, yPos + 23, -10461088, levelCheckActive && this.levelRange.isMaxLevelRelative(), ConfigureEnchantmentColorsScreen.this.f_96547_, levelCheckActive ? -1 : -12566464, (Component)Component.m_237115_((String)"cec.relative"), levelCheckActive);
            guiGraphics.m_280614_(ConfigureEnchantmentColorsScreen.this.f_96547_, (Component)Component.m_237115_((String)"cec.min_level"), ConfigureEnchantmentColorsScreen.this.leftPos + 165, yPos + 34, levelCheckActive ? -1 : -12566464, levelCheckActive);
            guiGraphics.m_280056_(ConfigureEnchantmentColorsScreen.this.f_96547_, levelCheckActive ? String.valueOf(this.levelRange.getMin()) : "0", ConfigureEnchantmentColorsScreen.this.leftPos + 165, yPos + 45, levelCheckActive ? -1 : -12566464, levelCheckActive);
            guiGraphics.m_280614_(ConfigureEnchantmentColorsScreen.this.f_96547_, (Component)Component.m_237115_((String)"cec.max_level"), ConfigureEnchantmentColorsScreen.this.leftPos + 190, yPos + 34, levelCheckActive ? -1 : -12566464, levelCheckActive);
            guiGraphics.m_280056_(ConfigureEnchantmentColorsScreen.this.f_96547_, levelCheckActive ? String.valueOf(this.levelRange.getMax()) : "0", ConfigureEnchantmentColorsScreen.this.leftPos + 190, yPos + 45, levelCheckActive ? -1 : -12566464, levelCheckActive);
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 280, yPos + 11, -10461088, this.bold, ConfigureEnchantmentColorsScreen.this.f_96547_, -1, (Component)Component.m_237115_((String)"cec.style.bold").m_130940_(ChatFormatting.BOLD));
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 280, yPos + 23, -10461088, this.underlined, ConfigureEnchantmentColorsScreen.this.f_96547_, -1, (Component)Component.m_237115_((String)"cec.style.underlined").m_130940_(ChatFormatting.UNDERLINE));
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 280, yPos + 35, -10461088, this.italic, ConfigureEnchantmentColorsScreen.this.f_96547_, -1, (Component)Component.m_237115_((String)"cec.style.italic").m_130940_(ChatFormatting.ITALIC));
            this.colorType.render(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 279, yPos + 46, 10);
            guiGraphics.m_280430_(ConfigureEnchantmentColorsScreen.this.f_96547_, (Component)Component.m_237115_((String)"cec.style.color"), ConfigureEnchantmentColorsScreen.this.leftPos + 291, yPos + 47, -16);
            UsefulTextures.renderCross(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 404 - 13, yPos + 1, 8);
        }

        public void mouseClicked(double relativeX, double relativeY, int code) {
            if (MathHelper.is2dBetween(relativeX, relativeY, 389, 1, 397, 9)) {
                ConfigureEnchantmentColorsScreen.this.elements.remove(this);
                ConfigureEnchantmentColorsScreen.this.recalculateScroll();
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 163, 10, 173, 20)) {
                this.toggleLevelReq();
            } else if (this.isEnchantmentAddHovered(relativeX, relativeY)) {
                ConfigureEnchantmentColorsScreen.this.active = this;
                ConfigureEnchantmentColorsScreen.this.selector = new ByNameRegistryElementSelectorWidget<Enchantment>(ConfigureEnchantmentColorsScreen.this.leftPos + 90, ConfigureEnchantmentColorsScreen.this.topPos + 20, 224, 146, (Component)Component.m_237115_((String)"cec.select_enchantment"), ConfigureEnchantmentColorsScreen.this.f_96547_, ForgeRegistries.ENCHANTMENTS, Enchantment::m_44704_, this.enchantments::add);
            } else if (this.isGroupAddHovered(relativeX, relativeY)) {
                ArrayList<EnchantmentGroup> groupValues = new ArrayList<EnchantmentGroup>(List.of(EnchantmentGroup.values()));
                groupValues.removeAll(this.groups);
                ConfigureEnchantmentColorsScreen.this.selector = new SelectEnumWidget<EnchantmentGroup>(ConfigureEnchantmentColorsScreen.this.leftPos + 152, ConfigureEnchantmentColorsScreen.this.topPos + 53, 100, 80, ConfigureEnchantmentColorsScreen.this.f_96547_, groupValues, EnchantmentGroup::getName, this::addGroup, (Component)Component.m_237115_((String)"cec.select_group"));
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 70, 10, 80, 60)) {
                int id = (int)((relativeY - 11.0) / 10.0);
                if (id < this.enchantments.size()) {
                    this.enchantments.remove(id);
                }
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 152, 10, 161, 60)) {
                int id = (int)((relativeY - 11.0) / 10.0);
                if (id < this.groups.size()) {
                    this.groups.remove(id);
                }
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 280, 11, 290, 21)) {
                this.bold = !this.bold;
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 280, 23, 290, 33)) {
                this.underlined = !this.underlined;
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 280, 35, 290, 45)) {
                this.italic = !this.italic;
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 280, 47, 290, 57)) {
                ConfigureEnchantmentColorsScreen.this.selector = new SelectChatColorWidget(ConfigureEnchantmentColorsScreen.this.leftPos + 178, ConfigureEnchantmentColorsScreen.this.topPos + 56, this::setColor, (Component)Component.m_237115_((String)"cec.select_color"), ConfigureEnchantmentColorsScreen.this.f_96547_, this.colorType);
            } else if (this.levelRange != null) {
                if (MathHelper.is2dBetween(relativeX, relativeY, 163, 22, 173, 32)) {
                    this.levelRange = new LevelRange(this.levelRange.getMin(), this.levelRange.getMax(), !this.levelRange.isMaxLevelRelative());
                } else if (MathHelper.is2dBetween(relativeX, relativeY, 165, 43, 185, 53)) {
                    if (this.levelRange.getMin() == this.levelRange.getMax() && !this.levelRange.isMaxLevelRelative()) {
                        return;
                    }
                    ConfigureEnchantmentColorsScreen.this.selector = new SelectCountWidget(ConfigureEnchantmentColorsScreen.this.leftPos + 102, ConfigureEnchantmentColorsScreen.this.topPos + 43, 200, ConfigureEnchantmentColorsScreen.this.f_96547_, this.levelRange.getMin(), this::setMinLevel, new IntegerNumberRange(-255, this.levelRange.getMax()), (Component)Component.m_237115_((String)"cec.select_level_bound.min"));
                } else if (MathHelper.is2dBetween(relativeX, relativeY, 190, 43, 210, 53)) {
                    ConfigureEnchantmentColorsScreen.this.selector = new SelectCountWidget(ConfigureEnchantmentColorsScreen.this.leftPos + 102, ConfigureEnchantmentColorsScreen.this.topPos + 43, 200, ConfigureEnchantmentColorsScreen.this.f_96547_, this.levelRange.getMax(), this::setMaxLevel, new IntegerNumberRange(this.levelRange.getMin(), 255), (Component)Component.m_237115_((String)"cec.select_level_bound.max"));
                }
            }
        }

        private void addGroup(EnchantmentGroup enchantmentGroup) {
            this.groups.add(enchantmentGroup);
            ConfigureEnchantmentColorsScreen.this.selector = null;
        }

        private void setColor(SelectChatColorWidget.ColorType colorType) {
            this.colorType = colorType;
        }

        private boolean isEnchantmentAddHovered(double relativeX, double relativeY) {
            if (ConfigureEnchantmentColorsScreen.this.selector != null) {
                return false;
            }
            int enchantmentAddY = 11 + this.enchantments.size() * 10;
            return MathHelper.is2dBetween(relativeX, relativeY, 4, enchantmentAddY, 12, enchantmentAddY + 8);
        }

        private boolean isGroupAddHovered(double relativeX, double relativeY) {
            if (ConfigureEnchantmentColorsScreen.this.selector != null) {
                return false;
            }
            int groupCount = this.groups.size();
            return groupCount < EnchantmentGroup.values().length && MathHelper.is2dBetween(relativeX, relativeY, 80, 11 + groupCount * 10, 88, 19 + groupCount * 10);
        }

        private EnchantmentColor color() {
            Style style = this.colorType.getStyle().m_131136_(Boolean.valueOf(this.bold)).m_131162_(Boolean.valueOf(this.underlined)).m_131155_(Boolean.valueOf(this.italic));
            return EnchantmentColor.create(this.name, this.enchantments, this.groups, this.levelRange, style);
        }

        public void toggleLevelReq() {
            this.levelRange = this.levelRange != null ? null : new LevelRange(0, 0, false);
        }

        public void setMinLevel(int min) {
            if (this.levelRange != null) {
                this.levelRange = this.levelRange.withMin(min);
            }
        }

        public void setMaxLevel(int max) {
            if (this.levelRange != null) {
                this.levelRange = this.levelRange.withMax(max);
            }
        }
    }
}

