/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.particle.DamageIndicatorParticleOptions;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageIndicatorParticle
extends Particle {
    public static final double MAX_MOVEMENT = 0.35;
    private static final char CRIT_CHAR = '\u2605';
    private float fadeout = -1.0f;
    private float prevFadeout = -1.0f;
    private final Font font;
    private final String text;
    private final int color;
    private final int darkColor;
    private float visualDY;
    private float prevVisualDY;
    private float visualDX;
    private float prevVisualDX;

    protected DamageIndicatorParticle(ClientLevel level, double x, double y, double z, double amount, double damageType, float rangeOffset, boolean critical) {
        super(level, x, y, z);
        Object text;
        this.font = Minecraft.m_91087_().f_91062_;
        this.visualDY = 0.0f;
        this.prevVisualDY = 0.0f;
        this.visualDX = 0.0f;
        this.prevVisualDX = 0.0f;
        Object object = text = amount == 3.4028234663852886E38 ? "INFINITE" : KapLibMod.doubleFormat(amount);
        if (critical) {
            text = "\u2605 " + (String)text + " \u2605";
        }
        this.text = text;
        this.color = TextHelper.damageIndicatorColorFromDouble(damageType).m_126665_();
        this.m_107253_(FastColor.ARGB32.m_13665_((int)this.color), FastColor.ARGB32.m_13667_((int)this.color), FastColor.ARGB32.m_13669_((int)this.color));
        this.darkColor = FastColor.ARGB32.m_13660_((int)255, (int)((int)(this.f_107227_ * 0.25f)), (int)((int)(this.f_107227_ * 0.25f)), (int)((int)((double)this.f_107227_ * 0.25)));
        this.f_107225_ = ClientModConfig.getIndicatorLifetime();
        this.f_107216_ = rangeOffset;
        this.f_107215_ = Mth.m_216263_((RandomSource)KapLibMod.RANDOM_SOURCE, (double)-0.35, (double)0.35) * (double)rangeOffset;
    }

    public void m_5744_(@NotNull VertexConsumer consumer, @NotNull Camera camera, float partialTicks) {
        Vec3 camPos = camera.m_90583_();
        float particleX = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float particleY = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float particleZ = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_252880_(particleX, particleY, particleZ);
        double distanceFromCam = new Vec3((double)particleX, (double)particleY, (double)particleZ).m_82553_();
        double inc = Mth.m_14008_((double)(distanceFromCam / 32.0), (double)0.0, (double)5.0);
        poseStack.m_85837_(0.0, (1.0 + inc / 4.0) * (double)Mth.m_14179_((float)partialTicks, (float)this.prevVisualDY, (float)this.visualDY), 0.0);
        float fadeout = Mth.m_14179_((float)partialTicks, (float)this.prevFadeout, (float)this.fadeout);
        float defScale = 0.006f;
        float scale = (float)((double)defScale * distanceFromCam);
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_85837_((1.0 + inc) * (double)Mth.m_14179_((float)partialTicks, (float)this.prevVisualDX, (float)this.visualDX), 0.0, 0.0);
        poseStack.m_85841_(-scale, -scale, scale);
        poseStack.m_85837_(0.0, 4.0 * (double)(1.0f - fadeout), 0.0);
        poseStack.m_85841_(fadeout, fadeout, fadeout);
        poseStack.m_85837_(0.0, -distanceFromCam / 8.0, 0.0);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        float x1 = 0.5f - (float)this.font.m_92895_(this.text) / 2.0f;
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        int light = 0xF000F0;
        this.font.m_271703_(this.text, x1, 0.0f, this.color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        poseStack.m_85837_(1.0, 1.0, 0.03);
        this.font.m_271703_(this.text, x1, 0.0f, this.darkColor, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, light);
        buffer.m_109911_();
        poseStack.m_85849_();
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            float length = 6.0f;
            this.prevFadeout = this.fadeout;
            this.fadeout = (float)this.f_107224_ > (float)this.f_107225_ - length ? ((float)this.f_107225_ - (float)this.f_107224_) / length : 1.0f;
            this.prevVisualDY = this.visualDY;
            this.visualDY = (float)((double)this.visualDY + this.f_107216_);
            this.prevVisualDX = this.visualDX;
            this.visualDX = (float)((double)this.visualDX + this.f_107215_);
            if (Math.sqrt(Math.pow((double)this.visualDX * 1.5, 2.0) + Math.pow(this.visualDY - 1.0f, 2.0)) < 0.8999999999999999) {
                this.f_107216_ /= 2.0;
            } else {
                this.f_107216_ = 0.0;
                this.f_107215_ = 0.0;
            }
        }
    }

    public static class Provider
    implements ParticleProvider<DamageIndicatorParticleOptions> {
        @Nullable
        public DamageIndicatorParticle createParticle(@NotNull DamageIndicatorParticleOptions particleType, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (!ClientModConfig.isIndicatorEnabled()) {
                return null;
            }
            return new DamageIndicatorParticle(level, x, y, z, particleType.getDamage(), particleType.getDamageType(), particleType.getRangeOffset(), particleType.isCritical());
        }
    }
}

