/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.core;

import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleAnimation;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTriggerInstance;
import net.minecraft.CrashReport;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.ApiStatus;

public class ParticleAnimator {
    private final ParticleAnimation animation;
    private final List<ParticleConfig> particles = new ArrayList<ParticleConfig>();
    private final ParticleSpawnSink sink = new ParticleSpawnSink(this);
    public int runningTicks;
    private int currentSpawnDelay;

    @ApiStatus.Internal
    public ParticleAnimator(ParticleAnimation animation) {
        TerminationTriggerInstance[] terminators;
        this.animation = animation;
        for (TerminationTriggerInstance terminator : terminators = animation.getTerminators()) {
            TerminationTrigger<? extends TerminationTriggerInstance> trigger = terminator.getTrigger();
            trigger.addListener(this, new TerminationTrigger.Listener<TerminationTriggerInstance>(terminator, this));
        }
        for (int i = 0; i < terminators.length; ++i) {
        }
    }

    @ApiStatus.Internal
    public void addParticle(Particle particle) {
        this.particles.add(new ParticleConfig(particle, this.animation));
    }

    @ApiStatus.Internal
    public void tick(RandomSource source) {
        if (this.currentSpawnDelay == 0) {
            this.animation.spawnTick(this.sink);
            this.currentSpawnDelay = Mth.m_216287_((RandomSource)source, (int)this.animation.minSpawnDelay, (int)this.animation.maxSpawnDelay);
        }
        --this.currentSpawnDelay;
        List<ParticleConfig> expired = this.particles.stream().filter(ParticleConfig::hasExpired).toList();
        expired.forEach(ParticleConfig::invalidate);
        this.particles.removeAll(expired);
        this.particles.forEach(ParticleConfig::tick);
        ++this.runningTicks;
    }

    public void fillCrashReport(CrashReport report) {
        report.m_127514_("Animator").m_128159_("runningTicks", (Object)this.runningTicks).m_128159_("currentSpawnDelay", (Object)this.currentSpawnDelay).m_128159_("Particles", this.particles);
        this.animation.fillCrashReport(report);
    }
}

