/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.elements;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleConfig;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface AnimationElement {
    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.Internal
    public static AnimationElement fromNw(FriendlyByteBuf buf) {
        Type elementType = (Type)buf.readRegistryIdUnsafe(ExtraRegistries.ANIMATION_ELEMENT_TYPES);
        return elementType.fromNW(buf);
    }

    @ApiStatus.Internal
    public static <T extends AnimationElement> void toNw(FriendlyByteBuf buf, T val) {
        Type<? extends AnimationElement> type = val.getType();
        buf.writeRegistryIdUnsafe(ExtraRegistries.ANIMATION_ELEMENT_TYPES, type);
        type.toNW(buf, val);
    }

    @NotNull
    public Type<? extends AnimationElement> getType();

    public int createLength(ParticleConfig var1);

    public void tick(ParticleConfig var1, int var2, double var3);

    default public void initialize(ParticleConfig object) {
    }

    default public void finalize(ParticleConfig config) {
    }

    public static interface Type<T extends AnimationElement> {
        public T fromNW(FriendlyByteBuf var1);

        public void toNW(FriendlyByteBuf var1, T var2);
    }

    public static interface Builder {
        public AnimationElement build();
    }
}

