/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.util.pos_target;

import java.util.function.Supplier;
import net.kapitencraft.kap_lib.client.util.pos_target.AbsolutePositionTarget;
import net.kapitencraft.kap_lib.client.util.pos_target.EntityBBPositionTarget;
import net.kapitencraft.kap_lib.client.util.pos_target.EntityPositionTarget;
import net.kapitencraft.kap_lib.client.util.pos_target.RelativePositionTarget;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IExtensibleEnum;

public interface PositionTarget
extends Supplier<Vec3> {
    public static PositionTarget fromNw(FriendlyByteBuf buf) {
        Types t = Types.values()[buf.readInt()];
        return t.type.fromNw(buf);
    }

    default public void toNw(FriendlyByteBuf buf) {
        Types.toNw(buf, this);
    }

    public static PositionTarget fixed(Vec3 pos) {
        return new AbsolutePositionTarget(pos);
    }

    public static PositionTarget relative(PositionTarget pos, Vec3 offset) {
        return new RelativePositionTarget(pos, offset);
    }

    public static PositionTarget entity(Entity entity) {
        return new EntityPositionTarget(entity.m_19879_(), EntityAnchorArgument.Anchor.FEET);
    }

    public static PositionTarget entityEyes(Entity entity) {
        return new EntityPositionTarget(entity.m_19879_(), EntityAnchorArgument.Anchor.EYES);
    }

    public static PositionTarget entityBB(Entity entity) {
        return new EntityBBPositionTarget(entity);
    }

    @Override
    public Vec3 get();

    public Types getType();

    public static enum Types implements IExtensibleEnum
    {
        ENTITY(EntityPositionTarget.Type::new),
        ENTITY_BB(EntityBBPositionTarget.Type::new),
        POS(AbsolutePositionTarget.Type::new),
        RELATIVE(RelativePositionTarget.Type::new);

        private final Type<? extends PositionTarget> type;

        private Types(Supplier<Type<? extends PositionTarget>> typeSupplier) {
            this.type = typeSupplier.get();
        }

        private static <T extends PositionTarget> void toNw(FriendlyByteBuf buf, T val) {
            Types types = val.getType();
            buf.writeInt(types.ordinal());
            types.type.toNw(buf, val);
        }

        public static Types create(String name, Supplier<Type<? extends PositionTarget>> typeSupplier) {
            throw new IllegalAccessError("enum not extended!");
        }
    }

    public static interface Type<T extends PositionTarget> {
        public void toNw(FriendlyByteBuf var1, T var2);

        public T fromNw(FriendlyByteBuf var1);
    }
}

