/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.util.pos_target;

import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.helpers.NetworkHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class RelativePositionTarget
implements PositionTarget {
    private final PositionTarget target;
    private final Vec3 offset;

    public RelativePositionTarget(PositionTarget target, Vec3 offset) {
        this.target = target;
        this.offset = offset;
    }

    @Override
    public Vec3 get() {
        return this.target.get().m_82549_(this.offset);
    }

    @Override
    public PositionTarget.Types getType() {
        return PositionTarget.Types.RELATIVE;
    }

    public String toString() {
        return "RelativePositionTarget[" + this.target + "], offset=" + this.offset;
    }

    public static class Type
    implements PositionTarget.Type<RelativePositionTarget> {
        @Override
        public void toNw(FriendlyByteBuf buf, RelativePositionTarget val) {
            val.target.toNw(buf);
            NetworkHelper.writeVec3(buf, val.offset);
        }

        @Override
        public RelativePositionTarget fromNw(FriendlyByteBuf buf) {
            return new RelativePositionTarget(PositionTarget.fromNw(buf), NetworkHelper.readVec3(buf));
        }
    }
}

