/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.cooldown;

import java.util.function.Consumer;
import java.util.function.Function;
import net.kapitencraft.kap_lib.cooldown.Cooldowns;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;

public class Cooldown {
    private final int defaultTime;
    private final Consumer<LivingEntity> toDo;

    public Cooldown(int defaultTime, Consumer<LivingEntity> toDo) {
        this.defaultTime = defaultTime;
        this.toDo = toDo;
    }

    public void applyCooldown(LivingEntity living, boolean reduceWithTime) {
        Cooldowns.get(living).applyCooldown(this, reduceWithTime);
    }

    public int getCooldownTime(LivingEntity living, boolean reduceWithTime) {
        double mul = reduceWithTime ? living.m_21133_((Attribute)ExtraAttributes.COOLDOWN_REDUCTION.get()) : 0.0;
        return (int)((double)this.defaultTime * (1.0 - mul / 100.0));
    }

    public int getActiveCooldownTime(LivingEntity living) {
        return Cooldowns.get(living).getCooldownTime(this);
    }

    public boolean isActive(LivingEntity entity) {
        return Cooldowns.get(entity).isActive(this);
    }

    public void onDone(LivingEntity living) {
        this.toDo.accept(living);
    }

    public Component createDisplay(LivingEntity living) {
        int cooldownTicks = this.getActiveCooldownTime(living);
        int defaultTime = MathHelper.cooldown(living, this.defaultTime);
        return Component.m_237110_((String)"cooldown.display", (Object[])new Object[]{cooldownTicks > 0 ? Component.m_237115_((String)"cooldown.active").m_130940_(ChatFormatting.RED).m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237113_((String)("(" + MathHelper.shortRound((double)cooldownTicks / 20.0) + "s)")).m_130940_(ChatFormatting.DARK_GRAY)) : Component.m_237115_((String)"cooldown.inactive").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)(", " + MathHelper.shortRound((double)defaultTime / 20.0) + "s")).m_130940_(ChatFormatting.DARK_GRAY))});
    }

    @ApiStatus.Experimental
    public static <T> void registerMappedCooldown(DeferredRegister<Cooldown> targetRegister, Function<T, String> function, String groupName, Consumer<LivingEntity> onExecute, Iterable<T> entries, int baseTime) {
        for (T entry : entries) {
            targetRegister.register(groupName + "/" + function.apply(entry), () -> new Cooldown(baseTime, onExecute));
        }
    }
}

