/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.crafting.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.registry.ExtraRecipeSerializers;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorRecipe
extends CustomRecipe {
    private final Ingredient material;
    private final List<ShapedRecipe> all;
    private final String group;

    public ArmorRecipe(ResourceLocation location, CraftingBookCategory p_249010_, Ingredient material, Map<ArmorType, ItemStack> all, String group) {
        super(location, p_249010_);
        this.material = material;
        this.group = group;
        this.all = MapStream.of(all).mapToSimple(this::create).toList();
    }

    private ShapedRecipe create(ArmorType type, ItemStack stack) {
        NonNullList<Ingredient> cost = type.makeIngredients(this.material);
        return new ShapedRecipe(this.m_6423_(), this.m_6076_(), this.m_245232_(), 3, cost.size() / 3, cost, stack);
    }

    public boolean matches(@NotNull CraftingContainer container, @NotNull Level level) {
        return this.all.stream().anyMatch(recipe -> recipe.m_5818_(container, level));
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        for (ShapedRecipe recipe : this.all) {
            if (!recipe.m_5818_(pContainer, null)) continue;
            return recipe.m_5874_(pContainer, pRegistryAccess);
        }
        return ItemStack.f_41583_;
    }

    public List<ShapedRecipe> getAll() {
        return this.all;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int i, int j) {
        return i == 3 && j == 3;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ExtraRecipeSerializers.ARMOR.get();
    }

    public static enum ArmorType implements StringRepresentable
    {
        HELMET("helmet", ArmorType.of(List.of(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), true)),
        CHESTPLATE("chestplate", ArmorType.of(List.of(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), false)),
        LEGGINGS("leggings", ArmorType.of(List.of(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), false)),
        BOOTS("boots", ArmorType.of(List.of(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), true));

        public static final StringRepresentable.EnumCodec<ArmorType> CODEC;
        private final String name;
        private final boolean small;
        private final boolean[][] data;

        public static ArmorType fromEquipmentSlot(ArmorItem.Type type) {
            return ArmorType.valueOf(type.m_266355_().toUpperCase());
        }

        public static ArmorType get(String name) {
            return (ArmorType)CODEC.m_262792_(name, (Enum)HELMET);
        }

        private static boolean[][] of(List<Boolean> list, boolean small) {
            int height = small ? 2 : 3;
            boolean[][] map = new boolean[3][height];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < height; ++j) {
                    map[i][j] = list.get(i + j * 3);
                }
            }
            return map;
        }

        private ArmorType(String name, boolean[][] data) {
            this.name = name;
            this.small = data[0].length == 2;
            this.data = data;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public NonNullList<Ingredient> makeIngredients(Ingredient main) {
            NonNullList list = NonNullList.m_122780_((int)(this.small ? 6 : 9), (Object)Ingredient.f_43901_);
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < (this.small ? 2 : 3); ++y) {
                    if (!this.data[x][y]) continue;
                    list.set(x + y * 3, (Object)main);
                }
            }
            return list;
        }

        static {
            CODEC = StringRepresentable.m_216439_(ArmorType::values);
        }
    }

    public static class Serializer
    implements RecipeSerializer<ArmorRecipe> {
        @NotNull
        public ArmorRecipe fromJson(@NotNull ResourceLocation location, @NotNull JsonObject object) {
            MapStream<ArmorType, ResourceLocation> map;
            String group = GsonHelper.m_13851_((JsonObject)object, (String)"group", (String)"");
            Ingredient material = Ingredient.m_43917_((JsonElement)object.get("material"));
            JsonArray unused = GsonHelper.m_13832_((JsonObject)object, (String)"unused", (JsonArray)new JsonArray());
            List<ArmorType> unusedSlots = unused.asList().stream().map(JsonElement::getAsString).map(ArmorType::get).toList();
            List<ArmorType> toUse = Arrays.stream(ArmorType.values()).filter(armorType -> !unusedSlots.contains(armorType)).toList();
            String results = GsonHelper.m_13851_((JsonObject)object, (String)"results", null);
            if (results != null) {
                Stream<ResourceLocation> stream = toUse.stream().map(ArmorType::m_7912_).map(s -> TextHelper.mergeRegister(results, s)).map(ResourceLocation::new);
                map = MapStream.create(toUse, stream.toList());
            } else {
                JsonArray array = GsonHelper.m_13832_((JsonObject)object, (String)"results", (JsonArray)new JsonArray());
                List<ResourceLocation> locations = array.asList().stream().map(JsonElement::getAsString).map(ResourceLocation::new).toList();
                map = MapStream.create(toUse, locations);
            }
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_216455_(GsonHelper.m_13851_((JsonObject)object, (String)"category", null));
            return new ArmorRecipe(location, category, material, map.mapValues(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).mapValues(ItemStack::new).toMap(), group);
        }

        @Nullable
        public ArmorRecipe fromNetwork(@NotNull ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            Ingredient material = Ingredient.m_43940_((FriendlyByteBuf)buf);
            List<String> items = CollectionHelper.create(4, () -> ((FriendlyByteBuf)buf).m_130277_());
            List<ItemStack> results = items.stream().filter(s -> !Objects.equals(s, "")).map(ResourceLocation::new).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).map(ItemStack::new).toList();
            List<ArmorType> types = Arrays.stream(ArmorType.values()).toList();
            Map<ArmorType, ItemStack> resultMap = MapStream.create(types, results).toMap();
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            return new ArmorRecipe(resourceLocation, category, material, resultMap, group);
        }

        public void toNetwork(FriendlyByteBuf buf, ArmorRecipe recipe) {
            buf.m_130070_(recipe.group);
            recipe.material.m_43923_(buf);
            recipe.all.stream().map(shapedRecipe -> shapedRecipe.m_8043_(null)).map(ItemStack::m_41720_).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7981_(arg_0)).map(ResourceLocation::toString).forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
            MiscHelper.repeat(4 - recipe.all.size(), integer -> buf.m_130070_(""));
            buf.m_130068_((Enum)recipe.m_245232_());
        }
    }
}

