/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class SpawnTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceLocation> requiredTables;
    private final List<SubProviderEntry> subProviders;

    public SpawnTableProvider(PackOutput pOutput, Set<ResourceLocation> pRequiredTables, List<SubProviderEntry> pSubProviders) {
        this.pathProvider = pOutput.m_245269_(PackOutput.Target.DATA_PACK, "spawn_tables");
        this.subProviders = pSubProviders;
        this.requiredTables = pRequiredTables;
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        final HashMap map = Maps.newHashMap();
        Object2ObjectOpenHashMap map1 = new Object2ObjectOpenHashMap();
        this.getTables().forEach(arg_0 -> SpawnTableProvider.lambda$run$1((Map)map1, map, arg_0));
        ValidationContext validationcontext = new ValidationContext(LootContextParamSets.f_81420_, new LootDataResolver(){

            @Nullable
            public <T> T m_278667_(LootDataId<T> pId) {
                return (T)(pId.f_278383_() == LootDataType.f_278413_ ? (SpawnTable)map.get(pId.f_278500_()) : null);
            }
        });
        this.validate(map, validationcontext);
        Multimap multimap = validationcontext.m_79352_();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(p_278900_ -> {
            ResourceLocation key = (ResourceLocation)p_278900_.getKey();
            SpawnTable table = (SpawnTable)p_278900_.getValue();
            Path path = this.pathProvider.m_245731_(key);
            return DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)SpawnTable.PARSER.toJsonTree((Object)table), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public List<SubProviderEntry> getTables() {
        return this.subProviders;
    }

    protected void validate(Map<ResourceLocation, SpawnTable> map, ValidationContext validationcontext) {
        for (ResourceLocation resourcelocation : Sets.difference(this.requiredTables, map.keySet())) {
            validationcontext.m_79357_("Missing built-in table: " + resourcelocation);
        }
        map.forEach((p_278897_, p_278898_) -> p_278898_.validate(validationcontext.m_79355_(p_278898_.getParamSet()).m_278632_("{" + p_278897_ + "}", new LootDataId(LootDataType.f_278413_, p_278897_))));
    }

    public final String m_6055_() {
        return "Spawn Tables";
    }

    private static /* synthetic */ void lambda$run$1(Map map1, Map map, SubProviderEntry subEntry) {
        subEntry.provider().get().generate((sequence, builder) -> {
            ResourceLocation location = map1.put(RandomSequence.m_288221_((ResourceLocation)sequence), sequence);
            if (location != null) {
                Util.m_143785_((String)("Spawn table random sequence seed collision on " + location + " and " + sequence));
            }
            builder.setRandomSequence((ResourceLocation)sequence);
            if (map.put(sequence, builder.setParamSet(subEntry.paramSet).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + sequence);
            }
        });
    }

    public record SubProviderEntry(Supplier<SubProvider> provider, LootContextParamSet paramSet) {
    }

    @FunctionalInterface
    protected static interface SubProvider {
        public void generate(BiConsumer<ResourceLocation, SpawnTable.Builder> var1);
    }
}

