/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.inventory.wearable;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.kapitencraft.kap_lib.inventory.page.equipment.EquipmentPage;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.io.network.ModMessages;
import net.kapitencraft.kap_lib.io.network.S2C.capability.SyncWearablesToPlayerPacket;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class Wearables
implements Container {
    public static final Capability<Wearables> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Wearables>(){});
    public static final WearableSlot[] SLOTS = Wearables.createSlots();
    private final NonNullList<ItemStack> content;
    private final LivingEntity entity;

    private static WearableSlot[] createSlots() {
        Collection collection = ExtraRegistries.WEARABLE_SLOTS.getValues();
        WearableSlot[] slots = new WearableSlot[collection.size()];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            WearableSlot slot;
            slots[slot.getSlotIndex()] = slot = (WearableSlot)iterator.next();
        }
        return slots;
    }

    public Wearables(LivingEntity entity) {
        this.entity = entity;
        this.content = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public static Wearables get(@NotNull LivingEntity living) {
        return (Wearables)living.getCapability(CAPABILITY).orElseThrow(() -> new IllegalArgumentException("capability not found!"));
    }

    public static void send(ServerPlayer sP) {
        Wearables wearables = Wearables.get((LivingEntity)sP);
        ModMessages.sendToClientPlayer(new SyncWearablesToPlayerPacket(sP.m_19879_(), (List<ItemStack>)wearables.content), sP);
    }

    public int m_6643_() {
        return SLOTS.length;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.content) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.content.get(pSlot);
    }

    public ItemStack get(WearableSlot slot) {
        return this.m_8020_(slot.getSlotIndex());
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        if (pAmount > 0 && this.content.get(pSlot) != ItemStack.f_41583_) {
            ItemStack stack = (ItemStack)this.content.get(pSlot);
            this.m_6836_(pSlot, ItemStack.f_41583_);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int pSlot) {
        ItemStack stack = (ItemStack)this.content.get(pSlot);
        this.content.set(pSlot, (Object)ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int pSlot, @NotNull ItemStack pStack) {
        EquipmentPage.equip(this.entity, SLOTS[pSlot], pStack, (ItemStack)this.content.get(pSlot));
        this.content.set(pSlot, (Object)pStack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        return pPlayer == this.entity;
    }

    public void m_6211_() {
    }

    public ListTag save() {
        ListTag tags = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            tags.add((Object)this.m_8020_(i).m_41739_(new CompoundTag()));
        }
        return tags;
    }

    public void load(ListTag tags) {
        for (int i = 0; i < tags.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tags.m_128728_(i));
            this.m_6836_(i, stack);
        }
    }

    public void copyFrom(List<ItemStack> content) {
        for (int i = 0; i < content.size(); ++i) {
            this.m_6836_(i, content.get(i));
        }
    }
}

