/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io.network.S2C.capability;

import java.util.List;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.io.network.S2C.capability.SyncCapabilityPacket;
import net.kapitencraft.kap_lib.item.capability.AbstractCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkEvent;

public abstract class SyncCapabilityToBlockPacket<D, C extends AbstractCapability<D>>
extends SyncCapabilityPacket<D, C> {
    private final BlockPos pos;

    protected SyncCapabilityToBlockPacket(List<D> data, BlockPos pos) {
        super(data);
        this.pos = pos;
    }

    public SyncCapabilityToBlockPacket(FriendlyByteBuf buf) {
        super(buf);
        this.pos = buf.m_130135_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.m_130064_(this.pos);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> sup) {
        sup.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            BlockEntity entity = level.m_7702_(this.pos);
            if (entity == null) {
                throw new IllegalStateException("unable to sync block data: BE not found");
            }
            int[] s = new int[1];
            entity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                    Object data = this.data.get(i);
                    if (data == null) continue;
                    this.updateCapability(iItemHandler.getStackInSlot(i), data);
                    s[0] = s[0] + 1;
                }
            });
            KapLibMod.LOGGER.info("synced {} Items to block {}", (Object)s[0], (Object)level.m_8055_(this.pos).m_60734_());
        });
    }
}

