/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.mixin.classes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Objects;
import net.kapitencraft.kap_lib.inventory.page.InventoryPage;
import net.kapitencraft.kap_lib.inventory.page_renderer.InventoryPageRenderer;
import net.kapitencraft.kap_lib.inventory.page_renderer.InventoryPageRenderers;
import net.kapitencraft.kap_lib.inventory.wrapper.RecipeBookButtonWrapper;
import net.kapitencraft.kap_lib.mixin.duck.inventory.InventoryPageIO;
import net.kapitencraft.kap_lib.mixin.duck.inventory.InventoryPageReader;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends AbstractContainerScreen<InventoryMenu> {
    @Shadow
    private float f_98831_;
    @Shadow
    private float f_98832_;
    @Unique
    private InventoryPageRenderer[] renderers;
    @Unique
    private int[] visible;
    @Unique
    private InventoryPageRenderer renderer;

    @Shadow
    protected abstract boolean m_6774_(int var1, int var2, int var3, int var4, double var5, double var7);

    @Shadow
    protected abstract void m_7856_();

    public InventoryScreenMixin(InventoryMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;setInitialFocus(Lnet/minecraft/client/gui/components/events/GuiEventListener;)V", shift=At.Shift.AFTER)})
    private void initPages(CallbackInfo ci) {
        InventoryPageReader reader = (InventoryPageReader)this.f_97732_;
        InventoryPage[] pages = reader.getPages();
        this.renderers = new InventoryPageRenderer[pages.length];
        this.visible = new int[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            InventoryPageRenderer renderer = this.renderers[i] = InventoryPageRenderers.getRenderer(pages[i]).construct(pages[i]);
            renderer.init(this.f_97735_, this.f_97736_);
            this.visible[i] = i;
        }
        this.renderer = this.renderers[reader.getPageIndex()];
    }

    @Redirect(method={"init"}, at=@At(value="NEW", target="(IIIIIIILnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/gui/components/Button$OnPress;)Lnet/minecraft/client/gui/components/ImageButton;"))
    private ImageButton wrapRecipeBookButton(int pX, int pY, int pWidth, int pHeight, int pXTexStart, int pYTexStart, int pYDiffTex, ResourceLocation pResourceLocation, Button.OnPress pOnPress) {
        return new RecipeBookButtonWrapper(pX, pY, pWidth, pHeight, pXTexStart, pYTexStart, pYDiffTex, pResourceLocation, pOnPress, (InventoryPageReader)this.f_97732_);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleMouseClicks(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        int relativeY = (int)pMouseY - this.f_97736_;
        int relativeX = (int)pMouseX - this.f_97735_;
        if (relativeX > 0 && relativeX < this.f_97726_) {
            InventoryPageIO pageIo;
            int index;
            if (relativeY > 0 && relativeY < this.f_97727_ && ((InventoryPageReader)this.f_97732_).getPageIndex() != 0) {
                if (this.renderer.onMouseClicked(relativeX, relativeY, pButton)) {
                    cir.setReturnValue((Object)true);
                }
            } else if (relativeY >= -32 && relativeY <= 0 && (index = relativeX / 28) < (pageIo = (InventoryPageIO)this.f_97732_).getPages().length && this.visible[index] != -1) {
                pageIo.setPage(this.visible[index]);
                this.renderer = this.renderers[this.visible[index]];
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleMouseRelease(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        int relativeY = (int)pMouseY - this.f_97736_;
        int relativeX = (int)pMouseX - this.f_97735_;
        if (relativeX > 0 && relativeX < this.f_97726_ && relativeY > 0 && relativeY < this.f_97727_ && ((InventoryPageReader)this.f_97732_).getPageIndex() != 0 && this.renderer.onMouseReleased(relativeX, relativeY, pButton)) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int relativeY = (int)pMouseY - this.f_97736_;
        int relativeX = (int)pMouseX - this.f_97735_;
        if (relativeX > 0 && relativeX < this.f_97726_ && relativeY > 0 && relativeY < this.f_97727_ && ((InventoryPageReader)this.f_97732_).getPageIndex() != 0) {
            return this.renderer.onMouseDragged(relativeX, relativeY, pButton);
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        int relativeY = (int)pMouseY - this.f_97736_;
        int relativeX = (int)pMouseX - this.f_97735_;
        if (relativeX > 0 && relativeX < this.f_97726_ && relativeY > 0 && relativeY < this.f_97727_ && ((InventoryPageReader)this.f_97732_).getPageIndex() != 0) {
            return this.renderer.onMouseScrolled(relativeX, relativeY, pDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    private void addPages(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, CallbackInfo ci) {
        InventoryPageReader reader = (InventoryPageReader)this.f_97732_;
        int selected = reader.getPageIndex();
        InventoryPage[] pages = reader.getPages();
        int index = 0;
        Arrays.fill(this.visible, -1);
        for (int i = 0; i < pages.length; ++i) {
            InventoryPage page = pages[i];
            if (!page.isVisible((Player)this.f_96541_.f_91074_)) continue;
            this.visible[index] = i;
            this.renderPageButton(pGuiGraphics, page, selected == i, index++);
        }
        if (selected != 0) {
            pGuiGraphics.m_280218_(this.renderer.pageBackgroundLocation(), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
            this.renderer.render(pGuiGraphics, this.f_96541_, pMouseX, pMouseY, this.f_98831_, this.f_98832_, this.f_97735_, this.f_97736_);
            ci.cancel();
        }
    }

    @Inject(method={"renderLabels"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelIfOtherPage(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, CallbackInfo ci) {
        if (((InventoryPageReader)this.f_97732_).getPageIndex() != 0) {
            ci.cancel();
        }
    }

    @Unique
    private void renderPageButton(GuiGraphics pGuiGraphics, InventoryPage page, boolean selected, int positionIndex) {
        int j = positionIndex == 0 ? 0 : 26;
        int k = 0;
        int l = this.f_97735_ + positionIndex * 28;
        int i1 = this.f_97736_ - 28;
        if (selected) {
            k += 32;
        }
        RenderSystem.enableBlend();
        pGuiGraphics.m_280168_().m_85836_();
        if (selected) {
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        }
        pGuiGraphics.m_280218_(page.tabLocation(), l, i1, j, k, 26, 32);
        l += 5;
        i1 += 9;
        if (!selected) {
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        }
        ItemStack itemstack = Objects.requireNonNull(page.symbol(), "InventoryPage has null symbol! " + page);
        pGuiGraphics.m_280480_(itemstack, l, i1);
        pGuiGraphics.m_280370_(this.f_96547_, itemstack, l, i1);
        pGuiGraphics.m_280168_().m_85849_();
    }
}

