/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.registry.custom.spawn_table;

import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.kapitencraft.kap_lib.spawn_table.ForgeGsonAdapterFactory;
import net.kapitencraft.kap_lib.spawn_table.entries.AlternativesEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.CompositeEntryBase;
import net.kapitencraft.kap_lib.spawn_table.entries.DynamicSpawn;
import net.kapitencraft.kap_lib.spawn_table.entries.EmptySpawnEntity;
import net.kapitencraft.kap_lib.spawn_table.entries.EntryGroup;
import net.kapitencraft.kap_lib.spawn_table.entries.SequentialEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnEffectCloud;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnEntity;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnTableReference;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public interface SpawnPoolEntries {
    public static final DeferredRegister<SpawnPoolEntryType> REGISTRY = KapLibMod.registry(ExtraRegistries.Keys.POOL_ENTRY_TYPES);
    public static final RegistryObject<SpawnPoolEntryType> ALTERNATIVES = SpawnPoolEntries.register("alternatives", CompositeEntryBase.createSerializer(AlternativesEntry::new));
    public static final RegistryObject<SpawnPoolEntryType> GROUP = SpawnPoolEntries.register("group", CompositeEntryBase.createSerializer(EntryGroup::new));
    public static final RegistryObject<SpawnPoolEntryType> SEQUENCE = SpawnPoolEntries.register("sequence", CompositeEntryBase.createSerializer(SequentialEntry::new));
    public static final RegistryObject<SpawnPoolEntryType> DYNAMIC = SpawnPoolEntries.register("dynamic", new DynamicSpawn.Serializer());
    public static final RegistryObject<SpawnPoolEntryType> EMPTY = SpawnPoolEntries.register("empty", new EmptySpawnEntity.Serializer());
    public static final RegistryObject<SpawnPoolEntryType> ENTITY = SpawnPoolEntries.register("entity", new SpawnEntity.Serializer());
    public static final RegistryObject<SpawnPoolEntryType> REFERENCE = SpawnPoolEntries.register("reference", new SpawnTableReference.Serializer());
    public static final RegistryObject<SpawnPoolEntryType> EFFECT_CLOUD = SpawnPoolEntries.register("effect_cloud", new SpawnEffectCloud.Serializer());

    public static RegistryObject<SpawnPoolEntryType> register(String name, SpawnPoolEntryContainer.Serializer<? extends SpawnPoolEntryContainer> serializer) {
        return REGISTRY.register(name, () -> new SpawnPoolEntryType(serializer));
    }

    public static Object createGsonAdapter() {
        return ForgeGsonAdapterFactory.builder(ExtraRegistries.SPAWN_POOL_ENTRY_TYPES, "entry", "type", SpawnPoolEntryContainer::getType).build();
    }
}

