/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolSingletonContainer;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class DynamicSpawn
extends SpawnPoolSingletonContainer {
    final ResourceLocation name;

    DynamicSpawn(ResourceLocation pDynamicDropsName, int pWeight, int pQuality, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions) {
        super(pWeight, pQuality, pConditions, pFunctions);
        this.name = pDynamicDropsName;
    }

    @Override
    public SpawnPoolEntryType getType() {
        return (SpawnPoolEntryType)((Object)SpawnPoolEntries.DYNAMIC.get());
    }

    @Override
    public void createEntity(Consumer<Entity> pEntityConsumer, SpawnContext pLootContext) {
        pLootContext.addDynamicSpawn(this.name, pEntityConsumer);
    }

    public static SpawnPoolSingletonContainer.Builder<?> dynamicEntry(ResourceLocation pDynamicDropsName) {
        return DynamicSpawn.simpleBuilder((p_79487_, p_79488_, p_79489_, p_79490_) -> new DynamicSpawn(pDynamicDropsName, p_79487_, p_79488_, p_79489_, p_79490_));
    }

    public static class Serializer
    extends SpawnPoolSingletonContainer.Serializer<DynamicSpawn> {
        @Override
        public void serializeCustom(JsonObject pObject, DynamicSpawn pContainer, JsonSerializationContext pConditions) {
            super.serializeCustom(pObject, pContainer, pConditions);
            pObject.addProperty("name", pContainer.name.toString());
        }

        @Override
        protected DynamicSpawn deserialize(JsonObject pObject, JsonDeserializationContext pContext, int pWeight, int pQuality, LootItemCondition[] pConditions, SpawnEntityFunction[] pFunctions) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)pObject, (String)"name"));
            return new DynamicSpawn(resourcelocation, pWeight, pQuality, pConditions, pFunctions);
        }
    }
}

