/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.util.pos_target;

import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.ExtraStreamCodecs;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;

public class EntityPositionTarget
implements PositionTarget {
    private final int target;
    private final EntityAnchorArgument.Anchor anchor;

    public EntityPositionTarget(int target, EntityAnchorArgument.Anchor anchor) {
        this.target = target;
        this.anchor = anchor;
    }

    @Override
    public Vec3 get() {
        return this.anchor.apply(ClientHelper.getEntity(this.target));
    }

    @Override
    public PositionTarget.Types getType() {
        return PositionTarget.Types.ENTITY;
    }

    public String toString() {
        return "EntityPositionTarget[" + this.target + "]";
    }

    public static class Type
    implements PositionTarget.Type<EntityPositionTarget> {
        private static final StreamCodec<? super RegistryFriendlyByteBuf, EntityPositionTarget> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, t -> t.target, (StreamCodec)ExtraStreamCodecs.enumCodec((Enum[])EntityAnchorArgument.Anchor.values()), t -> t.anchor, EntityPositionTarget::new);

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, EntityPositionTarget> codec() {
            return STREAM_CODEC;
        }
    }
}

