/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay.holder;

import java.util.List;
import java.util.function.Function;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.holder.Overlay;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;

public class MultiLineOverlay
extends Overlay {
    private final float yChange;
    private final List<Function<LocalPlayer, Component>> list;

    public MultiLineOverlay(Component name, OverlayProperties holder, float yChange, List<Function<LocalPlayer, Component>> allText) {
        super(holder, name);
        this.yChange = yChange;
        this.list = allText;
    }

    @Override
    public float getWidth(LocalPlayer player, Font font) {
        return TextHelper.getWidthFromMultiple(this.list.stream().map(func -> (Component)func.apply(player)).toList(), font);
    }

    @Override
    public float getHeight(LocalPlayer player, Font font) {
        return (float)this.list.size() * -this.yChange;
    }

    @Override
    public void render(Gui gui, GuiGraphics graphics, int screenWidth, int screenHeight, LocalPlayer player) {
        for (int i = 0; i < this.list.size(); ++i) {
            Function<LocalPlayer, Component> mapper = this.list.get(i);
            graphics.drawString(gui.getFont(), mapper.apply(player), 0, -((int)this.yChange) * i, -1);
        }
    }
}

