/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.inventory.wearable;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.inventory.wearable.Wearables;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public interface IWearable {
    default public Multimap<Holder<Attribute>, AttributeModifier> getModifiers(WearableSlot slot, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public WearableSlot getSlot();

    default public InteractionResultHolder<ItemStack> swapWithEquipmentSlot(Item pItem, Level pLevel, Player pPlayer, InteractionHand pHand) {
        WearableSlot wearableSlot;
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (pItem instanceof IWearable) {
            IWearable wearable = (IWearable)pItem;
            wearableSlot = wearable.getSlot();
        } else {
            wearableSlot = null;
        }
        WearableSlot slot = Objects.requireNonNull(wearableSlot, "item not wearable: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)pItem)));
        Wearables wearables = Wearables.get((LivingEntity)pPlayer);
        ItemStack original = wearables.get(slot);
        if (!EnchantmentHelper.has((ItemStack)original, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !ItemStack.matches((ItemStack)itemstack, (ItemStack)original)) {
            if (!pLevel.isClientSide()) {
                pPlayer.awardStat(Stats.ITEM_USED.get((Object)pItem));
            }
            ItemStack stack = original.isEmpty() ? itemstack : original.copyAndClear();
            ItemStack stack1 = itemstack.copyAndClear();
            wearables.setItem(slot.getSlotIndex(), stack1);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

