/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.loot_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import net.kapitencraft.kap_lib.registry.ExtraLootItemFunctions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class AttributeAmountModifierFunction
extends LootItemConditionalFunction {
    public static final MapCodec<AttributeAmountModifierFunction> CODEC = RecordCodecBuilder.mapCodec(attributeAmountModifierFunctionInstance -> AttributeAmountModifierFunction.commonFields((RecordCodecBuilder.Instance)attributeAmountModifierFunctionInstance).and((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(i -> i.modifier)).and((App)Formulas.CODEC.fieldOf("formula").forGetter(i -> i.formula)).apply((Applicative)attributeAmountModifierFunctionInstance, AttributeAmountModifierFunction::new));
    private final Holder<Attribute> modifier;
    private final Formulas formula;

    private AttributeAmountModifierFunction(List<LootItemCondition> conditions, Holder<Attribute> attribute, Formulas formula) {
        super(conditions);
        this.modifier = attribute;
        this.formula = formula;
    }

    public Holder<Attribute> getModifier() {
        return this.modifier;
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack stack, LootContext lootContext) {
        Entity source = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (source instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)source;
            double amount = living.getAttributeValue(this.modifier);
            return this.formula.provide(stack, amount);
        }
        return stack;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return ExtraLootItemFunctions.ATTRIBUTE_MODIFIER.get();
    }

    public static enum Formulas implements Formula,
    StringRepresentable
    {
        DEFAULT("default", (stack, d) -> stack.copyWithCount((int)((double)stack.getCount() * (1.0 + d / 100.0))));

        public static final StringRepresentable.EnumCodec<Formulas> CODEC;
        private final String name;
        private final BiFunction<ItemStack, Double, ItemStack> provider;

        private Formulas(String name, BiFunction<ItemStack, Double, ItemStack> provider) {
            this.name = name;
            this.provider = provider;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ItemStack provide(ItemStack stack, double d) {
            return this.provider.apply(stack, d);
        }

        public static Formulas byName(String name) {
            return (Formulas)CODEC.byName(name, (Enum)DEFAULT);
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Formulas::values);
        }
    }

    public static interface Formula {
        public String getName();

        public ItemStack provide(ItemStack var1, double var2);
    }
}

