/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.registry.custom.core;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.cam.modifiers.Modifier;
import net.kapitencraft.kap_lib.client.font.effect.GlyphEffect;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core.ActivationTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.elements.AnimationElement;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.ParticleFinalizer;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTrigger;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentBlockBreakEffect;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentBowEffect;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentCountEffect;
import net.kapitencraft.kap_lib.inventory.page.InventoryPageType;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.io.serialization.RegistrySerializer;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.requirements.conditions.abstracts.ReqCondition;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.ApiStatus;

public interface ExtraRegistries {
    @ApiStatus.Internal
    public static final List<Registry<?>> registries = new ArrayList();
    public static final Registry<OverlayProperties> OVERLAY_PROPERTIES = ExtraRegistries.reg(Keys.OVERLAY_PROPERTIES);
    public static final Registry<GlyphEffect> GLYPH_EFFECTS = ExtraRegistries.reg(Keys.GLYPH_EFFECTS);
    public static final Registry<RegistrySerializer<? extends ReqCondition<?>>> REQUIREMENT_TYPES = ExtraRegistries.reg(Keys.REQ_CONDITIONS);
    public static final Registry<RegistrySerializer<? extends Bonus<?>>> BONUS_SERIALIZER = ExtraRegistries.syncReg(Keys.BONUS_SERIALIZERS);
    public static final Registry<MapCodec<? extends EnchantmentBowEffect>> ENCHANTMENT_BOW_EFFECTS = ExtraRegistries.reg(Keys.ENCHANTMENT_BOW_EFFECTS);
    public static final Registry<MapCodec<? extends EnchantmentCountEffect>> ENCHANTMENT_COUNT_EFFECTS = ExtraRegistries.reg(Keys.ENCHANTMENT_COUNT_EFFECTS);
    public static final Registry<MapCodec<? extends EnchantmentBlockBreakEffect>> ENCHANTMENT_BLOCK_BREAK_EFFECTS = ExtraRegistries.reg(Keys.ENCHANTMENT_BLOCK_BREAK_EFFECTS);
    public static final Registry<AnimationElement.Type<?>> ANIMATION_ELEMENT_TYPES = ExtraRegistries.syncReg(Keys.MODIFIER_TYPES);
    public static final Registry<Spawner.Type<?>> SPAWN_ELEMENT_TYPES = ExtraRegistries.syncReg(Keys.SPAWNER_TYPES);
    public static final Registry<ParticleFinalizer.Type<?>> PARTICLE_FINALIZER_TYPES = ExtraRegistries.syncReg(Keys.FINALIZER_TYPES);
    public static final Registry<TerminationTrigger<?>> TERMINATION_TRIGGERS = ExtraRegistries.syncReg(Keys.TERMINATOR_TYPES);
    public static final Registry<ActivationTrigger<?>> ACTIVATION_TRIGGERS = ExtraRegistries.syncReg(Keys.ACTIVATION_TRIGGERS);
    public static final Registry<Modifier.Type<?>> CAMERA_MODIFIERS = ExtraRegistries.syncReg(Keys.CAMERA_MODIFIERS);
    public static final Registry<SpawnEntityFunctionType<?>> SPAWN_FUNCTION_TYPES = ExtraRegistries.reg(Keys.FUNCTION_TYPES);
    public static final Registry<SpawnPoolEntryType> SPAWN_POOL_ENTRY_TYPES = ExtraRegistries.reg(Keys.POOL_ENTRY_TYPES);
    public static final Registry<WearableSlot> WEARABLE_SLOTS = ExtraRegistries.reg(Keys.WEARABLE_SLOTS);
    public static final Registry<InventoryPageType<?>> INVENTORY_PAGES = ExtraRegistries.reg(Keys.INVENTORY_PAGES);
    public static final Registry<Cooldown> COOLDOWNS = ExtraRegistries.syncReg(Keys.COOLDOWNS);

    private static <T> Registry<T> reg(ResourceKey<Registry<T>> key) {
        Registry registry = new RegistryBuilder(key).create();
        registries.add(registry);
        return registry;
    }

    private static <T> Registry<T> syncReg(ResourceKey<Registry<T>> key) {
        Registry registry = new RegistryBuilder(key).sync(true).create();
        registries.add(registry);
        return registry;
    }

    @ApiStatus.Internal
    public static void registerAll(Consumer<Registry<?>> register) {
        registries.forEach(register);
    }

    public static interface Keys {
        public static final ResourceKey<Registry<OverlayProperties>> OVERLAY_PROPERTIES = Keys.createRegistry("overlay_properties");
        public static final ResourceKey<Registry<GlyphEffect>> GLYPH_EFFECTS = Keys.createRegistry("glyph_effects");
        public static final ResourceKey<Registry<RegistrySerializer<? extends ReqCondition<?>>>> REQ_CONDITIONS = Keys.createRegistry("requirement_conditions");
        public static final ResourceKey<Registry<RegistrySerializer<? extends Bonus<?>>>> BONUS_SERIALIZERS = Keys.createRegistry("bonus_serializers");
        public static final ResourceKey<Registry<MapCodec<? extends EnchantmentBowEffect>>> ENCHANTMENT_BOW_EFFECTS = Keys.createRegistry("enchantment_bow_effects");
        public static final ResourceKey<Registry<MapCodec<? extends EnchantmentCountEffect>>> ENCHANTMENT_COUNT_EFFECTS = Keys.createRegistry("enchantment_count_effects");
        public static final ResourceKey<Registry<MapCodec<? extends EnchantmentBlockBreakEffect>>> ENCHANTMENT_BLOCK_BREAK_EFFECTS = Keys.createRegistry("enchantment_block_break_effects");
        public static final ResourceKey<Registry<AnimationElement.Type<?>>> MODIFIER_TYPES = Keys.createRegistry("particle_animation/element_types");
        public static final ResourceKey<Registry<Spawner.Type<?>>> SPAWNER_TYPES = Keys.createRegistry("particle_animation/spawner_types");
        public static final ResourceKey<Registry<ParticleFinalizer.Type<?>>> FINALIZER_TYPES = Keys.createRegistry("particle_animation/finalizer_types");
        public static final ResourceKey<Registry<TerminationTrigger<?>>> TERMINATOR_TYPES = Keys.createRegistry("particle_animation/terminator_types");
        public static final ResourceKey<Registry<ActivationTrigger<?>>> ACTIVATION_TRIGGERS = Keys.createRegistry("particle_animation/activation_triggers");
        public static final ResourceKey<Registry<Modifier.Type<?>>> CAMERA_MODIFIERS = Keys.createRegistry("camera_modifiers");
        public static final ResourceKey<Registry<SpawnEntityFunctionType<?>>> FUNCTION_TYPES = Keys.createRegistry("spawn_table/function_types");
        public static final ResourceKey<Registry<SpawnPoolEntryType>> POOL_ENTRY_TYPES = Keys.createRegistry("spawn_table/pool_entry_types");
        public static final ResourceKey<Registry<SpawnTable>> SPAWN_TABLES = Keys.createRegistry("spawn_tables");
        public static final ResourceKey<Registry<WearableSlot>> WEARABLE_SLOTS = Keys.createRegistry("wearable_slots");
        public static final ResourceKey<Registry<InventoryPageType<?>>> INVENTORY_PAGES = Keys.createRegistry("inventory_pages");
        public static final ResourceKey<Registry<Cooldown>> COOLDOWNS = Keys.createRegistry("cooldowns");

        private static <T> ResourceKey<Registry<T>> createRegistry(String id) {
            return ResourceKey.createRegistryKey((ResourceLocation)KapLibMod.res(id));
        }

        private static <T> ResourceKey<Registry<T>> vanillaRegistry(String id) {
            return ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.withDefaultNamespace((String)id));
        }
    }
}

