/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util.range.simple;

import com.mojang.serialization.Codec;
import net.kapitencraft.kap_lib.util.range.simple.NumberRange;

public class IntegerNumberRange
extends NumberRange<Integer> {
    public static Codec<IntegerNumberRange> CODEC = Codec.LONG.xmap(IntegerNumberRange::fromPacked, IntegerNumberRange::pack);
    private final int min;
    private final int max;

    public IntegerNumberRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    private static IntegerNumberRange fromPacked(long in) {
        return new IntegerNumberRange((int)(in << 32), (int)in);
    }

    public long pack() {
        return (long)this.min >> 32 | (long)this.max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getRange() {
        return this.max - this.min;
    }

    @Override
    public boolean test(Integer integer) {
        return this.min <= integer && integer <= this.max;
    }
}

