/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.select;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kapitencraft.kap_lib.client.UsefulTextures;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class HolderByNameRegistryElementSelectorWidget<T>
extends PositionedWidget {
    private static final Component SELECT_PANEL = Component.translatable((String)"mco.template.button.select");
    private final Component title;
    protected final Font font;
    private final int titleWidth;
    protected float scroll;
    protected boolean scrolling;
    protected int maxScroll;
    protected final List<Holder<T>> allElements;
    protected Holder<T> selected;
    private final Consumer<Holder<T>> valueSink;
    private final Function<Holder<T>, String> keyExtractor;

    public HolderByNameRegistryElementSelectorWidget(int x, int y, int width, int height, Component title, Font font, Registry<T> registry, Consumer<Holder<T>> valueSink, Function<Holder<T>, String> keyExtractor) {
        super(x, y, width, height);
        this.keyExtractor = keyExtractor;
        this.allElements = new ArrayList<Holder<T>>();
        registry.holders().forEach(this.allElements::add);
        this.title = title;
        this.font = font;
        this.valueSink = valueSink;
        this.titleWidth = this.font.width((FormattedText)SELECT_PANEL);
        this.maxScroll = this.size() - (height - 22);
        this.scroll = 0.0f;
    }

    public final void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int widgetMiddle = this.x + this.width / 2;
        pGuiGraphics.fill(this.x, this.y, this.getMaxX(), this.getMaxY(), -16185079);
        pGuiGraphics.drawCenteredString(this.font, this.title, widgetMiddle, this.y + 1, 0xFFFFFF);
        pGuiGraphics.enableScissor(this.x + 1, this.y + 11, this.getMaxX() - 1, this.getMaxY() - 11);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)(this.x + 1), (float)(this.y + 11), 0.0f);
        this.renderInternal(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.pose().popPose();
        UsefulTextures.renderSliderWithLine(pGuiGraphics, 4, true, this.scroll / (float)(-this.maxScroll), this.getMaxX() - 1, this.y + 11, this.height - 22);
        pGuiGraphics.disableScissor();
        pGuiGraphics.drawString(this.font, SELECT_PANEL, this.getMaxX() - (this.titleWidth + 2), this.getMaxY() - 10, 0xFFFFFF);
    }

    protected int getHoveredIndex(double pMouseX, double pMouseY) {
        return ((int)pMouseY - this.y - (int)this.scroll - 10) / 12;
    }

    protected void renderInternal(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int middleX = this.width / 2 - 1;
        int id = 0;
        int hoveredIndex = (pMouseY - this.y - (int)this.scroll - 10) / 12;
        for (Holder<T> t : this.allElements) {
            graphics.fill(1, (int)this.scroll + 12 * id - 1, this.width - 1, (int)this.scroll + 12 * id + 9, this.selected == t ? -12566464 : (id == hoveredIndex ? -13619152 : -14671840));
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)this.keyExtractor.apply(t)), middleX, (int)this.scroll + 12 * id, 0xFFFFFF);
            ++id;
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int widgetMiddle = this.x + this.width / 2;
        int selectPos = this.getMaxX() - (this.titleWidth + 2);
        if (MathHelper.is2dBetween(pMouseX, pMouseY, this.getMaxX() - 7, this.y + 11, this.getMaxX() - 1, this.getMaxY() - 11)) {
            if (this.sliderHovered(pMouseY)) {
                this.scrolling = true;
            } else {
                double targetYPos = pMouseY - 2.5;
                this.scroll = (float)(((double)(this.y + 11) - targetYPos) * (double)this.maxScroll / (double)(this.height - 27));
                this.scroll = Mth.clamp((float)this.scroll, (float)(-this.maxScroll), (float)0.0f);
            }
            return true;
        }
        if (MathHelper.is2dBetween(pMouseX, pMouseY, selectPos - 1, this.getMaxY() - 10, selectPos + this.titleWidth + 1, this.getMaxY())) {
            if (this.selected != null) {
                this.valueSink.accept(this.selected);
                this.selected = null;
                return true;
            }
        } else if (this.getHoveredIndex(pMouseX, pMouseY) != -1) {
            this.selected = this.allElements.get(this.getHoveredIndex(pMouseX, pMouseY));
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    private boolean sliderHovered(double pMouseY) {
        float positionY = (float)(this.y + 11) + -this.scroll * (float)(this.height - 27) / (float)this.maxScroll;
        return MathHelper.isBetween(pMouseY, positionY, positionY + 5.0f);
    }

    protected int size() {
        return this.allElements.size();
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double scrollX, double scrollY) {
        if (MathHelper.is2dBetween(pMouseX, pMouseY, this.x + 1, this.y + 11, this.getMaxX() - 1, this.getMaxY() - 11)) {
            this.scroll += (float)(scrollY * ClientModConfig.getScrollScale());
            this.scroll = Mth.clamp((float)this.scroll, (float)(-this.maxScroll), (float)0.0f);
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling) {
            this.scroll = (float)(Mth.clamp((double)(pMouseY - (double)(this.y + 11)), (double)0.0, (double)(this.height - 11)) * (double)(-this.maxScroll) / (double)(this.height - 11));
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.scrolling) {
            this.scrolling = false;
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }
}

