/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kapitencraft.kap_lib.helpers.CollectorHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface InventoryHelper {
    public static boolean hasPlayerStackInInventory(Player player, Item item) {
        Inventory inventory = player.getInventory();
        return InventoryHelper.allInventory(inventory).stream().anyMatch(stack -> !stack.isEmpty() && stack.is(item));
    }

    public static void forInventory(Inventory inventory, Consumer<ItemStack> consumer) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            consumer.accept(inventory.getItem(i));
        }
    }

    public static Map<EquipmentSlot, ItemStack> equipment(LivingEntity living) {
        return Arrays.stream(EquipmentSlot.values()).collect(CollectorHelper.toMap(arg_0 -> ((LivingEntity)living).getItemBySlot(arg_0)));
    }

    public static Map<Integer, ItemStack> getAllContent(Inventory inventory) {
        HashMap<Integer, ItemStack> data = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            data.put(i, inventory.getItem(i));
        }
        return data;
    }

    public static List<ItemStack> allInventory(Inventory inventory) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        InventoryHelper.forInventory(inventory, list::add);
        return list;
    }

    public static boolean removeFromInventory(ItemStack stack, Player player) {
        Inventory inventory = player.getInventory();
        InventoryHelper.forInventory(inventory, stack1 -> {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stack1) && stack.getCount() > 0) {
                int size = Math.min(stack1.getCount(), stack.getCount());
                stack1.shrink(size);
                stack.shrink(size);
            }
        });
        return stack.getCount() <= 0;
    }

    public static int getFirstInventoryIndex(Item item, Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack currentStack = player.getInventory().getItem(i);
            if (currentStack.isEmpty() || !currentStack.is(item)) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getFirstStackInventoryIndex(Player player, Item item) {
        return InventoryHelper.allInventory(player.getInventory()).stream().filter(InventoryHelper.byItem(item)).findFirst().orElse(ItemStack.EMPTY);
    }

    public static Collection<ItemStack> getByFilter(Player player, Predicate<ItemStack> predicate) {
        return InventoryHelper.getContentByFilter(player, predicate).values();
    }

    public static Map<Integer, ItemStack> getContentByFilter(Player player, Predicate<ItemStack> predicate) {
        HashMap<Integer, ItemStack> itemStacks = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!predicate.test(stack)) continue;
            itemStacks.put(i, stack);
        }
        return itemStacks;
    }

    private static Predicate<ItemStack> byItem(Item item) {
        return stack -> stack.is(item);
    }

    public static boolean hasSetInInventory(Player player, Holder<ArmorMaterial> material) {
        ArrayList slots = new ArrayList();
        InventoryHelper.allInventory(player.getInventory()).stream().map(ItemStack::getItem).filter(item -> {
            ArmorItem armorItem;
            return item instanceof ArmorItem && (armorItem = (ArmorItem)item).getMaterial() == material;
        }).map(ArmorItem.class::cast).map(ArmorItem::getEquipmentSlot).forEach(slots::add);
        return !slots.isEmpty() && new HashSet(slots).containsAll(Arrays.stream(MiscHelper.ARMOR_EQUIPMENT).toList());
    }

    public static boolean hasInInventory(List<ItemStack> content, Player player) {
        return InventoryHelper.getRemaining(content, player).isEmpty();
    }

    public static List<ItemStack> getRemaining(List<ItemStack> content, Player player) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : content) {
            Collection<ItemStack> list = InventoryHelper.getByFilter(player, stack1 -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stack1));
            list.forEach(stack1 -> stack.shrink(stack1.getCount()));
            if (stack.getCount() <= 0) continue;
            ret.add(stack);
        }
        return ret;
    }
}

