/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class BannerPatternRenderer {
    private static final Minecraft MINECRAFT = Minecraft.getInstance();
    private static final ModelPart FLAG = MINECRAFT.getEntityModels().bakeLayer(ModelLayers.BANNER).getChild("flag");

    public static ModelPart getFlag() {
        return FLAG;
    }

    public static void renderBanner(GuiGraphics graphics, float x, float y, BannerPatternLayers patterns, DyeColor baseColor, int height) {
        MultiBufferSource.BufferSource source = MINECRAFT.renderBuffers().bufferSource();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(x, y + (float)height, 0.0f);
        float scale = (float)height / 40.0f;
        poseStack.scale(24.0f * scale, -24.0f * scale, 1.0f);
        poseStack.translate(0.5f, 0.5f, 0.0f);
        float f = 0.6666667f;
        poseStack.scale(f, -f, -f);
        BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)source, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelPart)FLAG, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)baseColor, (BannerPatternLayers)patterns);
        poseStack.popPose();
        source.endBatch();
    }

    public static void renderBannerFromStack(GuiGraphics graphics, int x, int y, ItemStack stack, int height) {
        BannerPatternRenderer.renderBanner(graphics, x, y, BannerPatternRenderer.fromStack(stack), ((BannerItem)stack.getItem()).getColor(), height);
    }

    public static BannerPatternLayers fromStack(ItemStack bannerStack) {
        return (BannerPatternLayers)bannerStack.get(DataComponents.BANNER_PATTERNS);
    }

    static {
        BannerPatternRenderer.FLAG.xRot = 0.0f;
        BannerPatternRenderer.FLAG.y = -32.0f;
    }
}

