/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.mixin.classes.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeBookComponent.class})
public class RecipeBookComponentMixin {
    @Shadow
    protected Minecraft minecraft;
    @Unique
    private RecipeHolder<?> lastRecipe = null;
    @Unique
    private RecipeCollection lastCollection = null;
    @Shadow
    @Final
    private RecipeBookPage recipeBookPage;

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void addRefill(int key, int x, int y, CallbackInfoReturnable<Boolean> cir) {
        if (key != 32) {
            return;
        }
        MultiPlayerGameMode gameMode = this.minecraft.gameMode;
        LocalPlayer player = this.minecraft.player;
        if (gameMode != null && player != null && this.lastRecipe != null && this.lastCollection != null && this.lastCollection.isCraftable(this.lastRecipe)) {
            gameMode.handlePlaceRecipe(player.containerMenu.containerId, this.lastRecipe, Screen.hasShiftDown());
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;handlePlaceRecipe(ILnet/minecraft/world/item/crafting/RecipeHolder;Z)V")})
    private void setLastRecipe(double p_100294_, double p_100295_, int p_100296_, CallbackInfoReturnable<Boolean> cir) {
        this.lastRecipe = this.recipeBookPage.getLastClickedRecipe();
        this.lastCollection = this.recipeBookPage.getLastClickedRecipeCollection();
    }
}

