/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.publish;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import net.kapitencraft.kap_lib.publish.AutoPublisher;

public class CurseforgePublish {
    private static final String API_URL = "https://minecraft.curseforge.com/api/projects/";

    static boolean publish(AutoPublisher.Config config) {
        String modId = config.modId();
        String modName = config.modName();
        String modVersion = config.modVersion();
        String mcVersion = config.mcVersion();
        String fmlVersion = config.loaderVersion();
        try {
            InputStream dataStream;
            URL url = new URL(API_URL + modId + "/upload-file");
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            String boundary = "----Boundary" + String.valueOf(UUID.randomUUID());
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            connection.setRequestProperty("User-Agent", String.format(config.author() + "/%s/%s (%s)", modName, modVersion, config.email()));
            connection.setRequestProperty("Authorization", AutoPublisher.getAuth(true));
            String fileBase = String.format("./build/libs/%s-", modId) + AutoPublisher.formatVersion(modVersion, mcVersion);
            File mainFile = new File(fileBase + ".jar");
            try (OutputStream outputStream = connection.getOutputStream();
                 PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);){
                CurseforgePublish.addData(writer, boundary, modName, modVersion, mcVersion, fmlVersion, config.projectId(), config.extraFiles(), config.dependencies());
                for (String extraFile : config.extraFiles()) {
                    File file = new File(fileBase + String.format("-%s.jar", extraFile));
                }
                outputStream.write(("--" + boundary + "--\r\n").getBytes());
                outputStream.flush();
            }
            int response = connection.getResponseCode();
            if (response != 200) {
                System.err.println("failed: " + response);
                dataStream = connection.getErrorStream();
            } else {
                dataStream = connection.getInputStream();
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(dataStream));
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(dataStream));
            Map data = (Map)AutoPublisher.GSON.fromJson(reader, Map.class);
            reader.close();
            if (response == 200) {
                System.out.println("successfully created new version with id '" + String.valueOf(data.get("id")) + "'");
                return true;
            }
            System.err.println("error: " + String.valueOf(data.get("error")));
            System.err.println("description: " + String.valueOf(data.get("description")));
        }
        catch (Exception e) {
            System.err.println("Error accessing API:");
            e.printStackTrace(System.err);
        }
        return false;
    }

    private static void addData(PrintWriter writer, String boundary, String modName, String modVersion, String mcVersion, String forgeVersion, String projectId, String[] extraFiles, JsonObject[] dependencies) {
        writer.append("--").append(boundary).append("\r\n");
        writer.append("Content-Disposition: form-data; name=\"data\"\r\n");
        writer.append("Content-Type: application/json; charset=UTF-8\r\n\r\n");
        writer.flush();
    }

    private static String addVersionData(String modName, String modVersion, String mcVersion, String forgeVersion, String projectId, JsonObject[] dependencies, String[] extraFiles) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("changelog", AutoPublisher.createChangelog());
        data.put("changelogType", "html");
        data.put("displayName", String.format("%s v%s", modName, modVersion));
        data.put("game_versions", new String[]{mcVersion});
        data.put("releaseType", "release");
        data.put("featured", true);
        data.put("status", "listed");
        data.put("project_id", projectId);
        String[] fileParts = new String[extraFiles.length + 1];
        System.arraycopy(extraFiles, 0, fileParts, 1, extraFiles.length);
        fileParts[0] = "primary";
        data.put("file_parts", fileParts);
        data.put("primary_file", "primary");
        return AutoPublisher.GSON.toJson(data);
    }
}

