/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.entries.AlternativesEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.ComposableEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.EntryGroup;
import net.kapitencraft.kap_lib.spawn_table.entries.SequentialEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.minecraft.Util;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class SpawnPoolEntryContainer
implements ComposableEntryContainer {
    protected final List<LootItemCondition> conditions;
    private final Predicate<LootContext> compositeCondition;

    protected SpawnPoolEntryContainer(List<LootItemCondition> pConditions) {
        this.conditions = pConditions;
        this.compositeCondition = Util.allOf(pConditions);
    }

    public void validate(ValidationContext pValidationContext) {
        for (int i = 0; i < this.conditions.size(); ++i) {
            this.conditions.get(i).validate(pValidationContext.forChild(".condition[" + i + "]"));
        }
    }

    protected final boolean canRun(SpawnContext pLootContext) {
        return this.compositeCondition.test(pLootContext);
    }

    public abstract SpawnPoolEntryType getType();

    protected static <T extends SpawnPoolEntryContainer> Products.P1<RecordCodecBuilder.Mu<T>, List<LootItemCondition>> commonFields(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(p_298548_ -> p_298548_.conditions));
    }

    public static abstract class Builder<T extends Builder<T>>
    implements ConditionUserBuilder<T> {
        private final List<LootItemCondition> conditions = Lists.newArrayList();

        protected abstract T getThis();

        public T when(LootItemCondition.Builder pConditionBuilder) {
            this.conditions.add(pConditionBuilder.build());
            return this.getThis();
        }

        public final T unwrap() {
            return this.getThis();
        }

        protected List<LootItemCondition> getConditions() {
            return this.conditions;
        }

        public AlternativesEntry.Builder otherwise(Builder<?> pChildBuilder) {
            return new AlternativesEntry.Builder(this, pChildBuilder);
        }

        public EntryGroup.Builder append(Builder<?> pChildBuilder) {
            return new EntryGroup.Builder(this, pChildBuilder);
        }

        public SequentialEntry.Builder then(Builder<?> pChildBuilder) {
            return new SequentialEntry.Builder(this, pChildBuilder);
        }

        public abstract SpawnPoolEntryContainer build();
    }
}

