/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.event.custom.RegisterUpdateCheckersEvent;
import net.kapitencraft.kap_lib.helpers.CollectorHelper;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.io.JsonHelper;
import net.kapitencraft.kap_lib.io.network.ModrinthUtils;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class UpdateChecker {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, UpdateData> projectData = new HashMap<String, UpdateData>();
    private static final Config config = UpdateChecker.loadConfig();

    private static Config loadConfig() {
        File file = new File(KapLibMod.ROOT, "update_checker_config.json");
        return IOHelper.loadOrCreateFile(file, Config.CODEC, () -> new Config(false, Channel.RELEASE));
    }

    public static void run() {
        RegisterUpdateCheckersEvent event = new RegisterUpdateCheckersEvent(UpdateChecker::registerUpdater);
        ModLoader.postEvent((Event)event);
        Thread thread = new Thread(UpdateChecker::checkUpdates, "Update Checker");
        if (UpdateChecker.config.autoUpdate) {
            thread.setPriority(10);
        }
        thread.start();
    }

    private static void registerUpdater(String projectId, String modId, Pattern versionExtractor) {
        projectData.put(projectId, new UpdateData(modId, versionExtractor));
    }

    private static void checkUpdates() {
        UpdateChecker.info("Starting Update check... (auto update " + (UpdateChecker.config.autoUpdate ? "enabled" : "disabled") + ")");
        List<Result> results = projectData.keySet().stream().map(UpdateChecker::checkUpdate).toList();
        ArrayList<Update> updates = new ArrayList<Update>();
        for (Result result : results) {
            result.log();
            if (result.type != Result.Type.OUTDATED) continue;
            updates.add(result.update);
        }
        UpdateChecker.info(String.format("Update check completed: %s update(s) available", updates.size()));
        if (UpdateChecker.config.autoUpdate && !updates.isEmpty()) {
            for (Update update : updates) {
                update.download();
            }
            UpdateChecker.info("Ending Programm.");
            if (FMLEnvironment.dist == Dist.CLIENT) {
                Minecraft.getInstance().stop();
            } else {
                System.exit(0);
            }
        }
    }

    private static Result checkUpdate(String projectId) {
        UpdateData updateData = projectData.get(projectId);
        IModFileInfo modInfo = ModList.get().getModFileById(updateData.modId);
        if (modInfo == null) {
            LOGGER.warn("no mod under id '{}' found", (Object)updateData.modId);
            return Result.unknown(updateData.modId);
        }
        try {
            UpdateChecker.info("running version check on '" + projectId + "'");
            ComparableVersion currentModVersion = new ComparableVersion(modInfo.versionString());
            Stream<JsonObject> rawVersionData = ModrinthUtils.readVersions(projectId, SharedConstants.getCurrentVersion().getName(), "KapLibAutoUpdater");
            if (rawVersionData == null) {
                LOGGER.warn("connection to {} failed", (Object)updateData.modId);
                return Result.connectionFailed(updateData.modId, currentModVersion);
            }
            Map<ComparableVersion, JsonObject> versionData = rawVersionData.collect(CollectorHelper.toKeyMappedStream(object -> {
                String versionNumber = GsonHelper.getAsString((JsonObject)object, (String)"version_number");
                Matcher matcher = updateData.versionExtractor.matcher(versionNumber);
                if (matcher.matches()) {
                    return matcher.group(1);
                }
                LOGGER.warn("unable to extract version from '{}' of mod {}", (Object)versionNumber, (Object)updateData.modId);
                return null;
            })).filterKeys(Objects::nonNull).mapKeys(ComparableVersion::new).toMap();
            if (versionData.isEmpty()) {
                LOGGER.warn("unable to find any versions.");
                return Result.failed(updateData.modId);
            }
            ArrayList<ComparableVersion> versions = new ArrayList<ComparableVersion>(versionData.keySet());
            versions.sort(ComparableVersion::compareTo);
            ComparableVersion newest = (ComparableVersion)versions.getLast();
            int compare = newest.compareTo(currentModVersion);
            if (compare > 0) {
                JsonObject newestVersionData = versionData.get(newest);
                JsonObject primaryFile = UpdateChecker.getPrimaryFile(newestVersionData);
                String fileUrl = GsonHelper.getAsString((JsonObject)primaryFile, (String)"url");
                String fileName = GsonHelper.getAsString((JsonObject)primaryFile, (String)"filename");
                int size = GsonHelper.getAsInt((JsonObject)primaryFile, (String)"size");
                return Result.outdated(currentModVersion, newest, new Update(fileUrl, fileName, modInfo.getFile().getFileName(), size), updateData.modId);
            }
            if (compare == 0) {
                return Result.upToDate(updateData.modId, currentModVersion);
            }
            return Result.ahead(updateData.modId, currentModVersion, newest);
        }
        catch (IOException e) {
            LOGGER.warn("error checking for update on project '{}'", (Object)updateData.modId);
        }
        catch (IllegalStateException | IndexOutOfBoundsException e) {
            LOGGER.warn("provided pattern for mod '{}' was unable to parse version string '{}'", (Object)updateData.modId, (Object)modInfo.versionString());
        }
        return Result.failed(updateData.modId);
    }

    private static JsonObject getPrimaryFile(JsonObject newestVersionData) {
        return JsonHelper.castToObjects(GsonHelper.getAsJsonArray((JsonObject)newestVersionData, (String)"files")).filter(o -> GsonHelper.getAsBoolean((JsonObject)o, (String)"primary")).findAny().get();
    }

    private static void downloadAndSaveUpdate(String fileUrl, String fileName, String oldFileName, int size) {
        try {
            UpdateChecker.info("Updating '" + fileName + "'");
            File modsDir = new File("./mods");
            File oldFile = new File(modsDir, oldFileName);
            if (!oldFile.exists()) {
                throw new IOException("Old file '" + oldFileName + "' not found");
            }
            URL url = new URL(fileUrl);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                int bytesRead;
                InputStream inputStream = httpConnection.getInputStream();
                File outputTarget = new File(modsDir, fileName);
                FileOutputStream outputStream = new FileOutputStream(outputTarget);
                byte[] buffer = new byte[4096];
                ProgressMeter downloadProgress = StartupNotificationManager.addProgressBar((String)("Downloading '" + fileName + "'"), (int)size);
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    downloadProgress.setAbsolute(downloadProgress.current() + bytesRead);
                }
                outputStream.close();
                inputStream.close();
                downloadProgress.complete();
                if (!oldFile.delete()) {
                    throw new IOException("unable to delete old file '" + oldFileName + "'");
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("error attempting to save update file: {}", (Object)e.getMessage());
        }
    }

    private static void info(String msg) {
        StartupNotificationManager.addModMessage((String)msg);
        LOGGER.info(Markers.UPDATE_CHECKER, msg);
    }

    private static String dependenciesToString(List<? extends IModInfo.ModVersion> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    private record Config(boolean autoUpdate, Channel channel) {
        private static final Codec<Config> CODEC = RecordCodecBuilder.create(configInstance -> configInstance.group((App)Codec.BOOL.optionalFieldOf("auto_update", (Object)false).forGetter(Config::autoUpdate), (App)Channel.CODEC.optionalFieldOf("channel", (Object)Channel.RELEASE).forGetter(Config::channel)).apply((Applicative)configInstance, Config::new));
    }

    private record UpdateData(String modId, Pattern versionExtractor) {
    }

    private record Result(@NotNull String modId, ComparableVersion currentVersion, ComparableVersion targetVersion, Update update, Type type) {
        public static Result unknown(String modId) {
            return new Result(modId, null, null, null, Type.UNKNOWN);
        }

        public static Result outdated(ComparableVersion currentModVersion, ComparableVersion newest, Update update, String modId) {
            return new Result(modId, currentModVersion, newest, update, Type.OUTDATED);
        }

        public static Result ahead(String modId, ComparableVersion currentModVersion, ComparableVersion newest) {
            return new Result(modId, currentModVersion, newest, null, Type.AHEAD);
        }

        public static Result connectionFailed(String modId, ComparableVersion currentModVersion) {
            return new Result(modId, currentModVersion, null, null, Type.CONNECTION_FAILED);
        }

        public static Result upToDate(String modId, ComparableVersion currentModVersion) {
            return new Result(modId, currentModVersion, null, null, Type.UP_TO_DATE);
        }

        public static Result failed(String modId) {
            return new Result(modId, null, null, null, Type.FAILED);
        }

        public void log() {
            UpdateChecker.info(String.format("status for '%s': %s, current=%s, target=%s", new Object[]{this.modId, this.type, this.currentVersion, this.targetVersion}));
        }

        private static enum Type {
            CONNECTION_FAILED,
            FAILED,
            UP_TO_DATE,
            OUTDATED,
            UNKNOWN,
            AHEAD;

        }
    }

    public static class Update {
        private final String downloadURL;
        private final String newFileName;
        private final String oldFileName;
        private final int size;

        public Update(String downloadURL, String newFileName, String oldFileName, int size) {
            this.downloadURL = downloadURL;
            this.newFileName = newFileName;
            this.oldFileName = oldFileName;
            this.size = size;
        }

        public void download() {
            UpdateChecker.downloadAndSaveUpdate(this.downloadURL, this.newFileName, this.oldFileName, this.size);
        }
    }

    private static enum Channel implements StringRepresentable
    {
        RELEASE("release"),
        BETA("beta"),
        ALPHA("alpha");

        private final String name;
        private static final StringRepresentable.EnumCodec<Channel> CODEC;

        private Channel(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        private boolean is(String val) {
            return this == ALPHA || (this == BETA ? !"alpha".equals(val) : "release".equals(val));
        }

        static {
            CODEC = StringRepresentable.fromEnum(Channel::values);
        }
    }
}

