/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.inventory.wearable;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.kapitencraft.kap_lib.inventory.page.equipment.EquipmentPage;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.io.network.S2C.capability.SyncWearablesToPlayerPacket;
import net.kapitencraft.kap_lib.registry.ModAttachmentTypes;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class Wearables
implements Container {
    public static final WearableSlot[] SLOTS = Wearables.createSlots();
    private final NonNullList<ItemStack> content;
    private LivingEntity owner;
    public static final Codec<Wearables> CODEC = NonNullList.codecOf((Codec)ItemStack.CODEC).xmap(Wearables::new, w -> w.content);

    private static WearableSlot[] createSlots() {
        List collection = ExtraRegistries.WEARABLE_SLOTS.stream().toList();
        WearableSlot[] slots = new WearableSlot[collection.size()];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            WearableSlot slot;
            slots[slot.getSlotIndex()] = slot = (WearableSlot)iterator.next();
        }
        return slots;
    }

    public Wearables() {
        this.content = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    private Wearables(NonNullList<ItemStack> list) {
        this.content = list;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public static Wearables get(@NotNull LivingEntity living) {
        Wearables data = Objects.requireNonNull((Wearables)living.getData(ModAttachmentTypes.WEARABLES.get()), "capability not found!");
        data.setOwner(living);
        return data;
    }

    public static void send(ServerPlayer sP) {
        Wearables wearables = Wearables.get((LivingEntity)sP);
        PacketDistributor.sendToPlayer((ServerPlayer)sP, (CustomPacketPayload)new SyncWearablesToPlayerPacket(sP.getId(), (List<ItemStack>)wearables.content), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public int getContainerSize() {
        return SLOTS.length;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.content) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.content.get(pSlot);
    }

    public ItemStack get(WearableSlot slot) {
        return this.getItem(slot.getSlotIndex());
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        if (pAmount > 0 && this.content.get(pSlot) != ItemStack.EMPTY) {
            ItemStack stack = (ItemStack)this.content.get(pSlot);
            this.setItem(pSlot, ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        ItemStack stack = (ItemStack)this.content.get(pSlot);
        this.content.set(pSlot, (Object)ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int pSlot, @NotNull ItemStack pStack) {
        EquipmentPage.equip(this.owner, SLOTS[pSlot], pStack, (ItemStack)this.content.get(pSlot));
        this.content.set(pSlot, (Object)pStack);
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return pPlayer == this.owner;
    }

    public void clearContent() {
    }

    public void copyFrom(List<ItemStack> content) {
        for (int i = 0; i < content.size(); ++i) {
            this.setItem(i, content.get(i));
        }
    }
}

