/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.glyph.enchantment_applicable;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import com.mojang.logging.LogUtils;
import java.util.function.Function;
import net.kapitencraft.kap_lib.KapLibMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.GlyphRenderTypes;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class EnchantmentApplicableAllocator
extends FontSet {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static EnchantmentApplicableAllocator instance;
    public static final ResourceLocation FONT;
    private static final GlyphInfo GLYPH_INFO;
    private int index = 1;
    private int maxIndex = 24;
    private final GlyphRenderTypes renderTypes = GlyphRenderTypes.m_284354_((ResourceLocation)InventoryMenu.f_39692_);
    private BakedGlyph[] glyphs;

    public EnchantmentApplicableAllocator(TextureManager manager) {
        super(manager, FONT);
        this.init();
        instance = this;
    }

    public static EnchantmentApplicableAllocator getInstance() {
        return instance;
    }

    @NotNull
    public GlyphInfo m_243128_(int pCharacter, boolean pFilterFishyGlyphs) {
        return GLYPH_INFO;
    }

    public char addEntry(ResourceLocation location) {
        if (this.index >= this.maxIndex) {
            this.reallocate();
        }
        int index = this.index++;
        Minecraft.m_91087_().m_6937_(() -> this.add(location, index));
        return (char)index;
    }

    private void reallocate() {
        KapLibMod.LOGGER.debug("re-allocating player head atlas");
        BakedGlyph[] oldGlyphs = this.glyphs;
        BakedGlyph[] newGlyphs = new BakedGlyph[oldGlyphs.length * 2];
        System.arraycopy(oldGlyphs, 0, newGlyphs, 0, oldGlyphs.length);
        this.glyphs = newGlyphs;
        this.maxIndex = newGlyphs.length - 1;
    }

    private synchronized void add(ResourceLocation resourceLocation, int index) {
        Function atlasGetter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        TextureAtlasSprite sprite = (TextureAtlasSprite)atlasGetter.apply(resourceLocation);
        this.addGlyph(index, sprite);
    }

    @NotNull
    public BakedGlyph m_95078_(int pCharacter) {
        return this.glyphs[pCharacter];
    }

    @NotNull
    public BakedGlyph m_95067_(GlyphInfo pGlyph) {
        return this.glyphs[Mth.m_216271_((RandomSource)KapLibMod.RANDOM_SOURCE, (int)0, (int)this.index)];
    }

    private void addGlyph(int index, TextureAtlasSprite sprite) {
        this.glyphs[index] = new BakedGlyph(this.renderTypes, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), 0.0f, 8.0f, 2.5f, 11.0f);
    }

    public void init() {
        this.glyphs = new BakedGlyph[25];
        this.index = 1;
        this.maxIndex = 24;
    }

    public void reset() {
        this.init();
    }

    static {
        FONT = KapLibMod.res("enchantment_applicable");
        GLYPH_INFO = new GlyphInfo(){

            public float m_7403_() {
                return 10.0f;
            }

            public BakedGlyph m_213604_(Function<SheetGlyphInfo, BakedGlyph> pGlyphProvider) {
                return null;
            }
        };
    }
}

