/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.OverlaysRegister;
import net.kapitencraft.kap_lib.client.overlay.box.ResizeBox;
import net.kapitencraft.kap_lib.client.overlay.holder.Overlay;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.event.ModEventFactory;
import net.kapitencraft.kap_lib.event.custom.client.RegisterConfigurableOverlaysEvent;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class OverlayManager {
    private static final Codec<OverlayManager> CODEC = RecordCodecBuilder.create(renderControllerInstance -> renderControllerInstance.group((App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, OverlayProperties.CODEC).fieldOf("storage").forGetter(OverlayManager::getLocations)).apply((Applicative)renderControllerInstance, OverlayManager::fromCodec));
    private static File PERSISTENT_FILE;
    private final Map<RegistryObject<OverlayProperties>, Function<OverlayProperties, Overlay>> constructors = new HashMap<RegistryObject<OverlayProperties>, Function<OverlayProperties, Overlay>>();
    public final Map<RegistryObject<OverlayProperties>, Overlay> map = new HashMap<RegistryObject<OverlayProperties>, Overlay>();
    private final List<Overlay> visible = new ArrayList<Overlay>();
    private final List<Overlay> invisible = new ArrayList<Overlay>();
    private final Map<ResourceLocation, OverlayProperties> loadedPositions = new HashMap<ResourceLocation, OverlayProperties>();

    private static OverlayManager fromCodec(Map<ResourceLocation, OverlayProperties> map) {
        OverlayManager controller = new OverlayManager();
        controller.loadedPositions.putAll(map);
        return controller;
    }

    public static void setVisible(Overlay overlay, boolean b) {
        OverlayManager manager = LibClient.overlays;
        if (b) {
            manager.visible.add(overlay);
            manager.invisible.remove(overlay);
        } else {
            manager.invisible.add(overlay);
            manager.visible.remove(overlay);
        }
    }

    private Map<ResourceLocation, OverlayProperties> getLocations() {
        return MapStream.of(this.map).mapValues(Overlay::getProperties).mapKeys(RegistryObject::getId).toMap();
    }

    @NotNull
    private static File getOrCreateFile() {
        if (PERSISTENT_FILE == null) {
            PERSISTENT_FILE = new File(KapLibMod.ROOT, "overlay_config.json");
        }
        return PERSISTENT_FILE;
    }

    public static OverlayManager load() {
        return IOHelper.loadFile(OverlayManager.getOrCreateFile(), CODEC, OverlayManager::new);
    }

    private OverlayManager() {
        this.register();
    }

    private void register() {
        OverlaysRegister.register(this);
        ModEventFactory.fireModEvent(new RegisterConfigurableOverlaysEvent(this::createRenderer));
        this.construct();
    }

    void createRenderer(RegistryObject<OverlayProperties> provider, Function<OverlayProperties, Overlay> constructor) {
        if (this.constructors.containsKey(provider)) {
            throw new IllegalStateException("detected double registered Overlay with ID '" + provider.getId() + "'");
        }
        this.constructors.put(provider, constructor);
    }

    public static void save() {
        IOHelper.saveFile(OverlayManager.getOrCreateFile(), CODEC, LibClient.overlays);
    }

    @SubscribeEvent
    public static void overlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("main", LibClient.overlays::render);
    }

    public void fillRenderBoxes(Consumer<ResizeBox> acceptor, BiConsumer<Overlay, ResizeBox> map, LocalPlayer player, Font font, float width, float height) {
        this.visible.forEach(overlay -> {
            ResizeBox box = overlay.newBox(width, height, player, font);
            acceptor.accept(box);
            map.accept((Overlay)overlay, box);
        });
    }

    private void render(ForgeGui forgeGui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (entity != null && !ClientHelper.hideGui()) {
            this.visible.forEach(renderHolder -> {
                graphics.m_280168_().m_85836_();
                OverlayProperties holder = renderHolder.getProperties();
                Vec2 renderLocation = renderHolder.getLoc(screenWidth, screenHeight);
                graphics.m_280168_().m_252880_(renderLocation.f_82470_, renderLocation.f_82471_, 0.0f);
                graphics.m_280168_().m_85841_(holder.getXScale(), holder.getYScale(), 0.0f);
                renderHolder.render(forgeGui, graphics, screenWidth, screenHeight, entity);
                graphics.m_280168_().m_85849_();
            });
        }
    }

    private void construct() {
        this.constructors.forEach((location, constructor) -> {
            OverlayProperties holder = MiscHelper.nonNullOr(this.loadedPositions.get(location.getId()), ((OverlayProperties)location.get()).createCopy());
            Overlay overlay = (Overlay)constructor.apply(holder);
            if (holder.isVisible()) {
                this.visible.add(overlay);
            } else {
                this.invisible.add(overlay);
            }
            this.map.put((RegistryObject<OverlayProperties>)location, overlay);
        });
    }

    public void reset(Overlay dedicatedHolder) {
        if (this.map.containsValue(dedicatedHolder)) {
            if (this.invisible.contains(dedicatedHolder)) {
                this.invisible.remove(dedicatedHolder);
                this.visible.add(dedicatedHolder);
            }
            RegistryObject<OverlayProperties> location = CollectionHelper.getKeyForValue(this.map, dedicatedHolder);
            dedicatedHolder.getProperties().copy((OverlayProperties)location.get());
            return;
        }
        throw new IllegalStateException("attempted to reset non-existing Holder");
    }

    public static void resetAll() {
        OverlayManager controller = LibClient.overlays;
        Set<RegistryObject<OverlayProperties>> locations = controller.constructors.keySet();
        locations.forEach(location -> {
            Overlay holder = controller.map.get(location);
            holder.getProperties().copy((OverlayProperties)location.get());
            controller.visible.add(holder);
        });
        controller.invisible.clear();
    }
}

