/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay;

import java.util.List;
import net.kapitencraft.kap_lib.client.overlay.OverlayManager;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.holder.MultiLineOverlay;
import net.kapitencraft.kap_lib.client.overlay.holder.SimpleOverlay;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.custom.Overlays;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class OverlaysRegister {
    public static void register(OverlayManager manager) {
        manager.createRenderer(Overlays.STATS, properties -> new MultiLineOverlay((Component)Component.m_237115_((String)"overlay.stats"), (OverlayProperties)properties, -10.0f, List.of(player -> Component.m_237110_((String)"overlay.stats.protection", (Object[])new Object[]{OverlaysRegister.getDamageProtection((LivingEntity)player)}).m_130940_(ChatFormatting.DARK_BLUE), player -> Component.m_237110_((String)"overlay.stats.ehp", (Object[])new Object[]{MathHelper.defRound((double)(player.m_21223_() * 100.0f) / (100.0 - OverlaysRegister.getDamageProtection((LivingEntity)player)))}).m_130940_(ChatFormatting.DARK_AQUA), player -> Component.m_237110_((String)"overlay.stats.speed", (Object[])new Object[]{OverlaysRegister.cancelGravityMovement((LivingEntity)player)}).m_130940_(ChatFormatting.YELLOW))));
        manager.createRenderer(Overlays.MANA, properties -> new SimpleOverlay((Component)Component.m_237115_((String)"overlay.mana"), (OverlayProperties)properties, player -> Component.m_237110_((String)"overlay.mana.display", (Object[])new Object[]{MathHelper.shortRound(player.m_21133_((Attribute)ExtraAttributes.MANA.get())), MathHelper.shortRound(player.getPersistentData().m_128459_("overflowMana")), player.m_21133_((Attribute)ExtraAttributes.MAX_MANA.get()), MathHelper.defRound(player.getPersistentData().m_128459_("manaRegen") * 20.0)}).m_130940_(ChatFormatting.BLUE)));
    }

    private static double getDamageProtection(LivingEntity living) {
        return MathHelper.defRound(100.0f - MathHelper.calculateDamage(100.0f, living.m_21133_(Attributes.f_22284_), living.m_21133_(Attributes.f_22285_)));
    }

    private static double cancelGravityMovement(LivingEntity living) {
        Vec3 delta = living.m_20184_();
        if (living.m_20096_()) {
            delta = delta.m_193103_(Direction.Axis.Y, 0.0);
        }
        return MathHelper.defRound(delta.m_82553_() * 20.0);
    }
}

